/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.operation;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.mule.datasense.impl.model.operation.InputArgument;
import org.mule.datasense.impl.model.operation.InputMapping;
import org.mule.datasense.impl.model.operation.InputParameter;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.LogSupport;
import org.mule.datasense.impl.util.extension.ExtensionUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class OperationCallBuilder
implements LogSupport {
    private String name = "";
    private Map<String, InputMappingBuilder> inputMappingsMap = new HashMap<String, InputMappingBuilder>();
    private MetadataType returnType = null;
    private Set<ErrorModel> errorModelSet = new LinkedHashSet<ErrorModel>();
    private String target;
    private String targetValueExpression;

    public OperationCallBuilder name(String name) {
        this.name = name;
        return this;
    }

    public OperationCallBuilder target(String target) {
        this.target = target;
        return this;
    }

    public OperationCallBuilder errors(Set<ErrorModel> errorModels) {
        this.errorModelSet.clear();
        this.errorModelSet.addAll(errorModels);
        return this;
    }

    public OperationCallBuilder targetValue(String targetValueExpression) {
        this.targetValueExpression = targetValueExpression;
        return this;
    }

    public OperationCallBuilder input(String name, Consumer<InputMappingBuilder> consumer) {
        InputMappingBuilder inputMappingBuilder = this.inputMappingsMap.get(name);
        if (inputMappingBuilder == null) {
            inputMappingBuilder = new InputMappingBuilder();
        }
        return this.input(inputMappingBuilder, consumer);
    }

    public OperationCallBuilder input(Consumer<InputMappingBuilder> consumer) {
        return this.input((String)null, consumer);
    }

    public OperationCallBuilder input(InputMappingBuilder inputMappingBuilder, Consumer<InputMappingBuilder> consumer) {
        consumer.accept(inputMappingBuilder);
        if (inputMappingBuilder.inputParameterBuilder != null) {
            String name = inputMappingBuilder.inputParameterBuilder.name;
            this.inputMappingsMap.put(name, inputMappingBuilder);
        }
        return this;
    }

    public OperationCallBuilder returnType(MetadataType returnType) {
        MetadataType effectiveMetadataType = returnType;
        if (this.returnType != null) {
            this.logger().debug("retyping {} with: {}", (Object)this.name, (Object)TypesHelper.toString(returnType));
            if (this.returnType instanceof MessageMetadataType && returnType instanceof MessageMetadataType) {
                MessageMetadataType previousReturnType = (MessageMetadataType)this.returnType;
                MessageMetadataType newReturnType = (MessageMetadataType)returnType;
                MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
                previousReturnType.getPayloadType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)messageMetadataTypeBuilder).payload(arg_0));
                newReturnType.getPayloadType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)messageMetadataTypeBuilder).payload(arg_0));
                previousReturnType.getAttributesType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)messageMetadataTypeBuilder).attributes(arg_0));
                newReturnType.getAttributesType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)messageMetadataTypeBuilder).attributes(arg_0));
                effectiveMetadataType = messageMetadataTypeBuilder.build();
            }
        }
        this.returnType = effectiveMetadataType;
        return this;
    }

    public OperationCall build() {
        return new OperationCall(this.name, this.inputMappingsMap.values().stream().filter(inputMappingBuilder -> !inputMappingBuilder.isOutput()).map(InputMappingBuilder::build), this.errorModelSet, this.returnType, this.target, this.targetValueExpression);
    }

    public static class InputArgumentBuilder {
        private String expression;

        public InputArgumentBuilder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public InputArgument build() {
            return new InputArgument(this.expression);
        }
    }

    public static class InputParameterBuilder {
        private String name;
        private MetadataType type;

        public InputParameterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InputParameterBuilder type(MetadataType type) {
            this.type = type;
            return this;
        }

        public InputParameter build() {
            return new InputParameter(this.name, this.type);
        }
    }

    public static class InputMappingBuilder {
        private InputParameterBuilder inputParameterBuilder = new InputParameterBuilder();
        private InputArgumentBuilder inputArgumentBuilder = new InputArgumentBuilder();

        public InputMappingBuilder parameter(Consumer<InputParameterBuilder> consumer) {
            consumer.accept(this.inputParameterBuilder);
            return this;
        }

        public InputMappingBuilder argument(Consumer<InputArgumentBuilder> consumer) {
            consumer.accept(this.inputArgumentBuilder);
            return this;
        }

        public boolean isOutput() {
            return ExtensionUtils.isOutputParameter(this.inputParameterBuilder.name);
        }

        public InputMapping build() {
            return new InputMapping(this.inputParameterBuilder.build(), this.inputArgumentBuilder.build());
        }
    }
}

