/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.mule.datasense.impl.model.annotations.InnerUsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.StructuralNodeTypeResolver;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;

public class AggregatorTypeResolver
extends StructuralNodeTypeResolver {
    private static final String PARAMETER_CONTENT = "content";
    private static final String PARAMETER_CONTENT_DEFAULT = "#[message]";
    private static final String AGGREGATOR_ATTRIBUTES_CLASS = "org.mule.extension.aggregator.internal.routes.AggregatorAttributes";

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    private Optional<MetadataType> resolveInnerElementType(final MessageProcessorNode messageProcessorNode, EventType inputEventType, final TypingMuleAstVisitorContext visitorContext) {
        return Optional.ofNullable(messageProcessorNode.getComponentModel()).map(componentModel -> {
            String contentData = Optional.ofNullable(componentModel.getParameters().get(PARAMETER_CONTENT)).orElse(PARAMETER_CONTENT_DEFAULT);
            return ExpressionLanguageUtils.extractExpression(contentData).map(e -> ExpressionLanguageUtils.resolveExpressionType(e, inputEventType, visitorContext.getTypeBindings(), visitorContext.getExpressionLanguageMetadataTypeResolver(), new ExpressionLanguageMetadataTypeResolver.MessageCallback((String)e){
                final /* synthetic */ String val$e;
                {
                    this.val$e = string;
                }

                public void warning(String message, ExpressionLanguageMetadataTypeResolver.MessageLocation messageLocation) {
                    visitorContext.getAstNotification().reportWarning(messageProcessorNode.getAstNodeLocation(), NotificationMessages.MSG_SCRIPTING_LANGUAGE_WARNING(this.val$e, message));
                }

                public void error(String message, ExpressionLanguageMetadataTypeResolver.MessageLocation messageLocation) {
                    visitorContext.getAstNotification().reportError(messageProcessorNode.getAstNodeLocation(), NotificationMessages.MSG_SCRIPTING_LANGUAGE_ERROR(this.val$e, message));
                }
            })).orElse(null);
        });
    }

    public static MetadataType aggregatorAttributesType() {
        return TypesHelper.getTypeFromJavaClass(AGGREGATOR_ATTRIBUTES_CLASS, AggregatorTypeResolver.class.getClassLoader()).orElse(AggregatorTypeResolver.fallbackAggregatorAttributesType());
    }

    private static MetadataType fallbackAggregatorAttributesType() {
        BaseTypeBuilder aggregatorAttributesTypeBuilder = TypesHelper.getTypeBuilder();
        ObjectTypeBuilder typeBuilder = aggregatorAttributesTypeBuilder.objectType();
        typeBuilder.addField().key("groupId").value().stringType();
        typeBuilder.addField().key("firstValueArrivalTime").value().numberType();
        typeBuilder.addField().key("lastValueArrivalTime").value().numberType();
        typeBuilder.addField().key("groupComplete").value().booleanType();
        return aggregatorAttributesTypeBuilder.build();
    }

    private EventType buildInnerEventType(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitorContext visitorContext) {
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        MessageMetadataTypeBuilder message = muleEventMetadataTypeBuilder.message();
        message.payload().arrayType().of(this.resolveInnerElementType(messageProcessorNode, inputEventType, visitorContext).orElse((MetadataType)TypesHelper.getTypeBuilder().anyType().build()));
        message.attributes(AggregatorTypeResolver.aggregatorAttributesType());
        MuleEventMetadataType muleEventMetadataType = muleEventMetadataTypeBuilder.build();
        return TypeUtils.asEventType(muleEventMetadataType);
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        EventType innerEventType = this.buildInnerEventType(messageProcessorNode, inputEventType, typingMuleAstVisitorContext);
        messageProcessorNode.annotate(new InnerUsesTypeAnnotation(innerEventType));
        messageProcessorNode.getMessageProcessorNodes().forEach(pipedMessageProcessorNode -> typingMuleAstVisitor.resolveType((AstNode)pipedMessageProcessorNode, TypeUtils.override(inputEventType, innerEventType), typingMuleAstVisitorContext));
        return new EventType();
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }

    @Override
    protected boolean isSequential() {
        return false;
    }
}

