/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.ExpectedEventAnnotation;
import org.mule.datasense.impl.model.annotations.ExpectedInputAnnotation;
import org.mule.datasense.impl.model.annotations.IncomingEventAnnotation;
import org.mule.datasense.impl.model.annotations.MessageProcessorTypeDeclarationAnnotation;
import org.mule.datasense.impl.model.annotations.ResultEventAnnotation;
import org.mule.datasense.impl.model.annotations.ThrowsErrorsTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitor;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitorContext;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.datasense.impl.util.MutableHolder;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;

public abstract class BaseTypeResolver
implements TypeResolver {
    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.empty();
    }

    @Override
    public final EventType resolveTypes(MessageProcessorNode messageProcessorNode, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        if (this.definesErrorHandlingContext()) {
            typingMuleAstVisitorContext.getErrorHandlingEnvironment().pushContext("node-" + messageProcessorNode.getName());
        }
        EventType argumentEventType = typingMuleAstVisitorContext.getTypingEnvironment().get().resolveInput();
        EventType declaredInputEventType = messageProcessorNode.getAnnotation(MessageProcessorTypeDeclarationAnnotation.class).flatMap(messageProcessorTypeDeclarationAnnotation -> {
            FunctionType functionType = messageProcessorTypeDeclarationAnnotation.getMessageProcessorTypeDeclaration().getFunctionType();
            return functionType.getParameters().stream().map(FunctionParameter::getType).filter(metadataType -> metadataType instanceof MuleEventMetadataType).map(metadataType -> TypeUtils.asEventType((MuleEventMetadataType)metadataType)).findFirst();
        }).orElse(new EventType());
        EventType retypedArgumentEventType = TypeUtils.merge(argumentEventType, declaredInputEventType);
        EventType resultEventType = this.resolve(messageProcessorNode, retypedArgumentEventType, typingMuleAstVisitor, typingMuleAstVisitorContext);
        messageProcessorNode.getAnnotation(ThrowsErrorsTypeAnnotation.class).ifPresent(throwsErrorsTypeAnnotation -> typingMuleAstVisitorContext.getErrorHandlingEnvironment().throwErrors(throwsErrorsTypeAnnotation.getErrors()));
        messageProcessorNode.getAnnotation(MessageProcessorTypeDeclarationAnnotation.class).ifPresent(messageProcessorTypeDeclarationAnnotation -> {
            FunctionType functionType = messageProcessorTypeDeclarationAnnotation.getMessageProcessorTypeDeclaration().getFunctionType();
            functionType.getParameters().stream().map(FunctionParameter::getType).filter(metadataType -> metadataType instanceof MuleEventMetadataType).map(metadataType -> TypeUtils.asEventType((MuleEventMetadataType)metadataType)).findFirst().ifPresent(eventType -> {
                UsesTypeAnnotation usesTypeAnnotation = (UsesTypeAnnotation)messageProcessorNode.getOrCreateAnnotation(UsesTypeAnnotation.class, () -> new UsesTypeAnnotation(new EventType()));
                usesTypeAnnotation.overrideWith((EventType)eventType);
            });
            functionType.getReturnType().filter(metadataType -> metadataType instanceof MuleEventMetadataType).map(metadataType -> TypeUtils.asEventType((MuleEventMetadataType)metadataType)).ifPresent(eventType -> {
                DefinesTypeAnnotation definesTypeAnnotation = (DefinesTypeAnnotation)messageProcessorNode.getOrCreateAnnotation(DefinesTypeAnnotation.class, () -> new DefinesTypeAnnotation(new EventType()));
                definesTypeAnnotation.overrideWith((EventType)eventType);
            });
        });
        Optional<EventType> usesEventType = messageProcessorNode.getAnnotation(UsesTypeAnnotation.class).map(UsesTypeAnnotation::getUsesEventType);
        Optional<EventType> definesEventType = messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).map(DefinesTypeAnnotation::getDefinesEventType);
        EventType outputEventType = new EventType();
        if (this.isPropagates(messageProcessorNode)) {
            outputEventType = TypeUtils.merge(outputEventType, argumentEventType);
        }
        if (!this.isScope()) {
            outputEventType = TypeUtils.merge(outputEventType, resultEventType);
        }
        if (definesEventType.isPresent()) {
            outputEventType = TypeUtils.merge(outputEventType, definesEventType.get());
        }
        if (this.definesErrorHandlingContext()) {
            typingMuleAstVisitorContext.getErrorHandlingEnvironment().popContext();
        }
        return outputEventType;
    }

    protected boolean definesErrorHandlingContext() {
        return true;
    }

    protected EventType unifyEventTypes(EventType sourceEventType, EventType targetEventType, boolean source) {
        return source ? sourceEventType : targetEventType;
    }

    protected abstract EventType resolve(MessageProcessorNode var1, EventType var2, TypingMuleAstVisitor var3, TypingMuleAstVisitorContext var4);

    protected abstract boolean isPropagates(MessageProcessorNode var1);

    @Override
    public EventType generateIncoming(MessageProcessorNode messageProcessorNode, IncomingAstVisitor incomingAstVisitor, IncomingAstVisitorContext visitorContext) {
        EventType incomingEventType = visitorContext.getIncomingEventType();
        IncomingEventAnnotation incomingEventAnnotation = new IncomingEventAnnotation(incomingEventType);
        messageProcessorNode.annotate(incomingEventAnnotation);
        MutableHolder<EventType> propagatedEvent = new MutableHolder<EventType>(incomingEventType);
        messageProcessorNode.getMessageProcessorNodes().forEach(innerMessageProcessorNode -> {
            visitorContext.setIncomingEventType(propagatedEvent.getValue().orElse(new EventType()));
            EventType childEventType = (EventType)innerMessageProcessorNode.accept(incomingAstVisitor, visitorContext);
            if (this.isSequential()) {
                propagatedEvent.setValue(childEventType);
            }
        });
        EventType declaredOutputEventType = messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).map(DefinesTypeAnnotation::getDefinesEventType).orElse(new EventType());
        EventType outputEventType = new EventType();
        if (this.isPropagates(messageProcessorNode)) {
            outputEventType = TypeUtils.merge(outputEventType, incomingEventType);
        }
        if (!this.isScope()) {
            outputEventType = TypeUtils.merge(outputEventType, propagatedEvent.getValue().orElse(new EventType()));
        }
        outputEventType = TypeUtils.merge(outputEventType, declaredOutputEventType);
        visitorContext.logger().exit(messageProcessorNode.getName());
        messageProcessorNode.annotate(new ResultEventAnnotation(outputEventType));
        return outputEventType;
    }

    protected EventType resolveInnerExpectedInputEventType(EventType expectedInputEventType, MessageProcessorNode messageProcessorNode, ExpectedAstVisitor expectedAstVisitor, ExpectedAstVisitorContext visitorContext) {
        return expectedInputEventType;
    }

    protected EventType resolveInnerExpectedOutputEventType(EventType expectedOutputEventType, MessageProcessorNode messageProcessorNode, ExpectedAstVisitor expectedAstVisitor, ExpectedAstVisitorContext visitorContext) {
        return expectedOutputEventType;
    }

    @Override
    public EventType generateExpected(MessageProcessorNode messageProcessorNode, ExpectedAstVisitor expectedAstVisitor, ExpectedAstVisitorContext visitorContext) {
        EventType expectedEventType = visitorContext.getExpectedEventType();
        ExpectedEventAnnotation expectedEventAnnotation = new ExpectedEventAnnotation(expectedEventType);
        messageProcessorNode.annotate(expectedEventAnnotation);
        EventType expectedOutputEventType = this.resolveInnerExpectedOutputEventType(expectedEventType, messageProcessorNode, expectedAstVisitor, visitorContext);
        MutableHolder<EventType> propagatedEvent = new MutableHolder<EventType>(this.isScope() ? new EventType() : expectedOutputEventType);
        if (this.isSequential()) {
            messageProcessorNode.getMessageProcessorNodes().collect(Collectors.toCollection(LinkedList::new)).descendingIterator().forEachRemaining(innerMessageProcessorNode -> {
                visitorContext.setExpectedEventType(propagatedEvent.getValue().orElse(new EventType()));
                EventType childEventType = (EventType)innerMessageProcessorNode.accept(expectedAstVisitor, visitorContext);
                propagatedEvent.setValue(childEventType);
            });
        } else {
            ArrayList<EventType> childEventTypes = new ArrayList<EventType>();
            messageProcessorNode.getMessageProcessorNodes().forEach(childMessageProcessorNode -> {
                visitorContext.setExpectedEventType(propagatedEvent.getValue().orElse(new EventType()));
                EventType childEventType = (EventType)childMessageProcessorNode.accept(expectedAstVisitor, visitorContext);
                childEventTypes.add(childEventType);
            });
            propagatedEvent.setValue(TypeUtils.intersection(childEventTypes));
        }
        EventType inputEventType = new EventType();
        EventType declaredOutputEventType = messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).map(DefinesTypeAnnotation::getDefinesEventType).orElse(new EventType());
        if (this.isPropagates(messageProcessorNode)) {
            inputEventType = TypeUtils.merge(inputEventType, expectedEventType);
            inputEventType = TypeUtils.minus(inputEventType, declaredOutputEventType);
        }
        inputEventType = TypeUtils.merge(inputEventType, propagatedEvent.getValue().orElse(new EventType()));
        EventType declaredInputEventType = messageProcessorNode.getAnnotation(UsesTypeAnnotation.class).map(UsesTypeAnnotation::getUsesEventType).orElse(this.resolveExpectedInputEventType(propagatedEvent.getValue().orElse(new EventType()), messageProcessorNode, expectedAstVisitor, visitorContext));
        inputEventType = TypeUtils.merge(inputEventType, declaredInputEventType);
        inputEventType = TypeUtils.filter(inputEventType, TypeUtils.USE_EVENT_PREDICATE);
        messageProcessorNode.annotate(new ExpectedInputAnnotation(inputEventType));
        visitorContext.logger().exit(messageProcessorNode.getName());
        return inputEventType;
    }

    protected EventType resolveExpectedInputEventType(EventType innerEventType, MessageProcessorNode messageProcessorNode, ExpectedAstVisitor expectedAstVisitor, ExpectedAstVisitorContext visitorContext) {
        return new EventType();
    }

    @Override
    public Optional<MuleAstParseProvider> getParseProvider() {
        return Optional.empty();
    }

    protected boolean isScope() {
        return false;
    }

    protected boolean isSequential() {
        return true;
    }

    protected ExpressionLanguageMetadataTypeResolver.MessageCallback createMessageCallback(final AstNotification astNotification, final AstNodeLocation astNodeLocation) {
        return new ExpressionLanguageMetadataTypeResolver.MessageCallback(){

            public void warning(String message, ExpressionLanguageMetadataTypeResolver.MessageLocation messageLocation) {
                astNotification.reportWarning(astNodeLocation, NotificationMessages.MSG_SCRIPTING_LANGUAGE_WARNING("", message));
            }

            public void error(String message, ExpressionLanguageMetadataTypeResolver.MessageLocation messageLocation) {
                astNotification.reportError(astNodeLocation, NotificationMessages.MSG_SCRIPTING_LANGUAGE_ERROR("", message));
            }
        };
    }
}

