/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import java.util.Set;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.ThrowsErrorsTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TargetProcessingSupport;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.config.internal.model.ComponentModel;

public class FlowRefTypeResolver
extends SingleNodeTypeResolver {
    private static final String ATTR_TARGET = "target";
    private static final String ATTR_TARGET_VALUE = "targetValue";
    private final TargetProcessingSupport targetProcessingSupport = new TargetProcessingSupport();

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    private EventType processTarget(EventType eventType, MessageProcessorNode messageProcessorNode, TypingMuleAstVisitorContext visitorContext) {
        ComponentModel componentModel = messageProcessorNode.getComponentModel();
        String target = (String)componentModel.getParameters().get(ATTR_TARGET);
        String targetValue = (String)componentModel.getParameters().get(ATTR_TARGET_VALUE);
        return this.targetProcessingSupport.processTarget(target, targetValue, eventType, visitorContext, this.createMessageCallback(visitorContext.getAstNotification(), messageProcessorNode.getAstNodeLocation()));
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        Optional usesTypeAnnotation = Optional.empty();
        Optional definesTypeAnnotation = Optional.empty();
        String referredFlowName = messageProcessorNode.getComponentModel().getNameAttribute();
        if (!ExpressionLanguageUtils.isExpression(referredFlowName)) {
            MuleApplicationNode muleApplicationNode = visitorContext.getAnnotation(MuleApplicationAnnotation.class).map(MuleApplicationAnnotation::getMuleApplicationNode).orElseThrow(() -> new IllegalArgumentException("Mule application node not set."));
            MuleFlowNode muleFlowNode = muleApplicationNode.findMuleFlowNode(referredFlowName).orElse(null);
            if (muleFlowNode != null) {
                usesTypeAnnotation = muleFlowNode.getAnnotation(UsesTypeAnnotation.class);
                definesTypeAnnotation = muleFlowNode.getAnnotation(DefinesTypeAnnotation.class);
                if (!definesTypeAnnotation.isPresent()) {
                    typingMuleAstVisitor.resolveType(muleFlowNode, TypeUtils.createEventType(null), visitorContext.getAstNotification(), muleApplicationNode);
                    definesTypeAnnotation = muleFlowNode.getAnnotation(DefinesTypeAnnotation.class);
                }
                muleFlowNode.getAnnotation(ThrowsErrorsTypeAnnotation.class).map(ThrowsErrorsTypeAnnotation::getErrors).ifPresent(errorModels -> messageProcessorNode.annotate(new ThrowsErrorsTypeAnnotation((Set<ErrorModel>)errorModels)));
            } else {
                visitorContext.getAstNotification().reportError(messageProcessorNode.getAstNodeLocation(), I18nMessageFactory.createStaticMessage((String)"Failed to solve flow-ref. Flow '%s' not found.", (Object[])new Object[]{referredFlowName}));
            }
        }
        messageProcessorNode.annotate(usesTypeAnnotation.orElse(new UsesTypeAnnotation(new EventType())));
        EventType definesEventType = definesTypeAnnotation.map(DefinesTypeAnnotation::getDefinesEventType).orElse(new EventType());
        definesEventType = this.processTarget(definesEventType, messageProcessorNode, visitorContext);
        messageProcessorNode.annotate(new DefinesTypeAnnotation(definesEventType));
        return definesEventType;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }
}

