/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import com.google.common.base.Strings;
import java.util.ArrayDeque;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorNode;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class ErrorTreeUtils {
    private static void log(Object o) {
        System.out.println(o);
    }

    public static void dump(ErrorNode errorNode) {
        errorNode.accept(new ErrorNode.ErrorNodeVisitor(){
            private int level;

            private void println(Object o) {
                ErrorTreeUtils.log(Strings.repeat((String)"\t", (int)this.level) + o);
            }

            @Override
            public void visit(ErrorNode errorNode) {
                this.println(errorNode.getErrorModel().map(errorModel -> String.format("%s:%s", errorModel.getNamespace(), errorModel.getType())).orElse("root"));
                ++this.level;
                errorNode.getChildren().forEach(this::visit);
                --this.level;
            }
        });
    }

    private static Iterable<ErrorModel> buildErrorTypePath(ErrorModel errorType) {
        ArrayDeque<ErrorModel> errorTypePath = new ArrayDeque<ErrorModel>();
        ErrorModel currentErrorModel = errorType;
        while (currentErrorModel != null) {
            errorTypePath.push(currentErrorModel);
            currentErrorModel = currentErrorModel.getParent().orElse(null);
        }
        return errorTypePath;
    }

    private static void add(ErrorNode errorNode, ErrorModel errorModel) {
        Iterable<ErrorModel> errorTypePath = ErrorTreeUtils.buildErrorTypePath(errorModel);
        errorNode.add(errorTypePath.iterator(), null);
    }

    public static ErrorNode createTree(Iterable<ErrorModel> errorModels) {
        ErrorNode result = new ErrorNode(null);
        errorModels.forEach(errorType -> ErrorTreeUtils.add(result, errorType));
        return result;
    }
}

