package org.mule.datasense.api.metadataprovider;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class DefaultApplicationModel implements ApplicationModel {

  private final String name;
  private org.mule.runtime.config.internal.model.ApplicationModel applicationModel;
  private final List<String> typesDataList;
  private final Function<String, Optional<URI>> resourceResolver;

  public DefaultApplicationModel(String name,
                                 org.mule.runtime.config.internal.model.ApplicationModel applicationModel) {
    this(name, applicationModel, null);
  }

  public DefaultApplicationModel(String name,
                                 org.mule.runtime.config.internal.model.ApplicationModel applicationModel,
                                 String typesData) {
    this(name, applicationModel, Collections.singletonList(typesData), null);
  }

  public DefaultApplicationModel(String name,
                                 org.mule.runtime.config.internal.model.ApplicationModel applicationModel,
                                 List<String> typesDataList,
                                 Function<String, Optional<URI>> resourceResolver) {
    this.name = name;
    this.applicationModel = applicationModel;
    this.typesDataList = new ArrayList<>();
    this.typesDataList.addAll(typesDataList);
    this.resourceResolver = resourceResolver;
  }

  public String getName() {
    return name;
  }

  public org.mule.runtime.config.internal.model.ApplicationModel getMuleApplicationModel() {
    return applicationModel;
  }

  @Override
  public org.mule.runtime.config.internal.model.ComponentModel findRootComponentModel() {
    return getMuleApplicationModel().getRootComponentModel();
  }

  @Override
  public Optional<org.mule.runtime.config.internal.model.ComponentModel> findNamedComponent(String name) {
    return getMuleApplicationModel().findTopLevelNamedComponent(name);
  }

  @Override
  public List<String> findTypesDataList() {
    return typesDataList;
  }

  public Optional<Function<String, Optional<URI>>> getResourceResolver() {
    return Optional.ofNullable(resourceResolver);
  }

  @Override
  public Optional<URI> findResource(String resource) {
    return getResourceResolver().map(resourceResolver -> resourceResolver.apply(resource)).orElse(Optional.empty());
  }
}
