package org.mule.datasense.api.metadataprovider;

import com.google.common.base.Preconditions;
import org.mule.runtime.api.meta.model.ExtensionModel;

import java.util.Optional;
import java.util.Set;

public class DefaultDataSenseProvider implements DataSenseProvider {

  private final ExtensionsProvider extensionsProvider;
  private final DataSenseMetadataProvider dataSenseMetadataProvider;

  public DefaultDataSenseProvider(ExtensionsProvider extensionsProvider, DataSenseMetadataProvider dataSenseMetadataProvider) {
    Preconditions.checkNotNull(extensionsProvider);
    this.extensionsProvider = extensionsProvider;
    this.dataSenseMetadataProvider = dataSenseMetadataProvider;
  }

  @Override
  public Set<ExtensionModel> getExtensions() {
    return extensionsProvider.getExtensions();
  }

  public Optional<DataSenseMetadataProvider> getDataSenseMetadataProvider() {
    return Optional.ofNullable(dataSenseMetadataProvider);
  }
}
