package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.annotations.HasDynamicMetadataAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.OperationModelAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.util.Utils;
import org.mule.datasense.impl.util.extension.DslElementModelWalker;
import org.mule.datasense.impl.util.extension.ExtensionUtils;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.config.api.dsl.model.DslElementModel;

import java.util.Optional;

public class StaticDslOperationAnnotator extends StaticDslBaseAnnotator {

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    final Optional<DslElementModel<OperationModel>> objectDslElementModel =
        annotatingMuleAstVisitorContext.getDataSenseProviderResolver().getDslElementModelFactory()
            .create(messageProcessorNode.getComponentModel().getConfiguration());
    objectDslElementModel.ifPresent(operationModelDslElementModel -> {
      if (operationModelDslElementModel.getModel() instanceof OperationModel) {
        final OperationModel operationModel = operationModelDslElementModel.getModel();
        messageProcessorNode.annotate(new OperationModelAnnotation(operationModel));
        OperationCallBuilder operationCallBuilder =
            messageProcessorNode
                .getOrCreateAnnotation(OperationCallBuilderAnnotation.class,
                                       OperationCallBuilderAnnotation::new)
                .getOperationCallBuilder();

        ExtensionUtils.findTarget(messageProcessorNode.getComponentModel()).ifPresent(target -> {
          operationCallBuilder.target(target);
          Utils.selectOptional(
                               () -> ExtensionUtils.findTargetValue(messageProcessorNode.getComponentModel()),
                               () -> ExtensionUtils.findDefaultTargetValue(operationModel))
              .ifPresent(expression -> {
                operationCallBuilder.targetValue(expression);
              });
        });
        ExtensionUtils.findOutputMimeType(messageProcessorNode.getComponentModel()).ifPresent(outputMimeType -> {
          operationCallBuilder.outputMimeType(outputMimeType);
        });

        final OperationCallDslElementModelVisitor dslElementModelVisitor =
            new OperationCallDslElementModelVisitor(operationCallBuilder);

        DslElementModelWalker dslElementModelWalker = new DslElementModelWalker();
        dslElementModelWalker.walkDslElementModel(operationModelDslElementModel, dslElementModelVisitor);

        if (dslElementModelVisitor.isHasDynamicType()) {
          messageProcessorNode.annotate(new HasDynamicMetadataAnnotation());
        }
      }
    });
  }
}
