package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;

public class UnknownTypeResolverAnnotator extends BaseAnnotator {

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    if (!messageProcessorNode.isRootMessageProcessorNode()) {
      if (!messageProcessorNode.getAnnotation(TypeResolverAnnotation.class).isPresent()) {
        messageProcessorNode.getComponentModelType().ifPresent(componentModelType -> {
          switch (componentModelType) {
            case MESSAGE_PROCESSOR_NODE:
              messageProcessorNode
                  .annotate(new TypeResolverAnnotation(DefaultDataSense.COMPONENT_IDENTIFIER_UNKNOWN_PROCESSOR));
              annotatingMuleAstVisitorContext.getAstNotification()
                  .reportWarning(messageProcessorNode.getAstNodeLocation(),
                                 NotificationMessages.MSG_UNKNOWN_FLOW_COMPONENT(messageProcessorNode));
              break;
          }
        });
      }
    }
  }
}
