package org.mule.datasense.impl.phases.builder;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

import java.util.function.Consumer;

public class MuleFlowNodeBuilder implements AstNodeBuilder<MuleFlowNode> {

  private final ComponentIdentifier componentIdentifier;
  private MessageProcessorNodeBuilder messageProcessorNodeBuilder;
  private ComponentModel componentModel;

  public MuleFlowNodeBuilder(ComponentIdentifier componentIdentifier) {
    this.componentIdentifier = componentIdentifier;
  }

  public MuleFlowNodeBuilder config(ComponentModel componentModel) {
    this.componentModel = componentModel;
    return this;
  }

  public MuleFlowNodeBuilder messageProcessor(ComponentIdentifier componentIdentifier,
                                              Consumer<MessageProcessorNodeBuilder> messageProcessorNodeBuilderConsumer) {
    MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
    messageProcessorNodeBuilderConsumer.accept(messageProcessorNodeBuilder);
    return messageProcessor(messageProcessorNodeBuilder);
  }

  public MuleFlowNodeBuilder messageProcessor(MessageProcessorNodeBuilder messageProcessorNodeBuilder) {
    messageProcessorNodeBuilder.root();
    this.messageProcessorNodeBuilder = messageProcessorNodeBuilder;
    return this;
  }

  public MuleFlowNode build() {
    MuleFlowNode muleFlowNode;
    if (messageProcessorNodeBuilder != null) {
      MessageProcessorNode messageProcessorNode = messageProcessorNodeBuilder.build();
      muleFlowNode = new MuleFlowNode(componentIdentifier, componentModel, messageProcessorNode);
      messageProcessorNode.setParentAstNode(muleFlowNode);
    } else {
      muleFlowNode = new MuleFlowNode(componentIdentifier, componentModel);
    }
    return muleFlowNode;
  }
}
