package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.util.MessageCallbackFactory;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;

import com.google.common.base.Preconditions;
import org.mule.metadata.message.api.el.TypeBindings;

public class ResolveTypeContext {

  private final ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver;
  private MessageCallbackFactory messageCallbackFactory;
  private TypeBindings typeBindings;

  public ResolveTypeContext(
                            ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver,
                            MessageCallbackFactory messageCallbackFactory, TypeBindings typeBindings) {
    this.typeBindings = typeBindings;
    Preconditions.checkNotNull(expressionLanguageMetadataTypeResolver);
    Preconditions.checkNotNull(messageCallbackFactory);
    this.expressionLanguageMetadataTypeResolver = expressionLanguageMetadataTypeResolver;
    this.messageCallbackFactory = messageCallbackFactory;
  }

  public ExpressionLanguageMetadataTypeResolver getExpressionLanguageMetadataTypeResolver() {
    return expressionLanguageMetadataTypeResolver;
  }

  public MessageCallbackFactory getMessageCallbackFactory() {
    return messageCallbackFactory;
  }

  public TypeBindings getTypeBindings() {
    return typeBindings;
  }
}
