package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ErrorNode {

  interface ErrorNodeVisitor {

    void visit(ErrorNode errorNode);
  }

  private ErrorModel errorModel;
  private List<ErrorNode> children;

  public ErrorNode(ErrorModel errorModel) {
    this.errorModel = errorModel;
    this.children = new ArrayList<>();
  }

  public Optional<ErrorModel> getErrorModel() {
    return Optional.ofNullable(errorModel);
  }

  public Stream<ErrorNode> getChildren() {
    return children.stream();
  }

  public void add(Iterator<ErrorModel> errorModelIterator, ErrorModel parentErrorModel) {
    if (!(errorModelIterator.hasNext())) {
      return;
    }

    final ErrorModel errorModel = errorModelIterator.next();
    ErrorNode selectedErrorNode = children.stream().filter(errorNode -> {
      final ErrorModel errorNodeErrorModel =
          errorNode.getErrorModel().orElseThrow(() -> new RuntimeException("ErrorModel not set"));
      return Objects.equals(errorNodeErrorModel.getNamespace(), errorModel.getNamespace())
          && Objects.equals(errorNodeErrorModel.getType(), errorModel.getType());
    }).findFirst().orElse(null);
    ErrorModel newParentErrorModel;
    if (selectedErrorNode == null) {
      final ErrorModel errorModel1 =
          ErrorModelBuilder.newError(errorModel.getType(), errorModel.getNamespace()).withParent(parentErrorModel).build();
      selectedErrorNode = new ErrorNode(
                                        errorModel1);
      children.add(selectedErrorNode);
      newParentErrorModel = errorModel1;
    } else {
      newParentErrorModel = selectedErrorNode.getErrorModel().orElse(null);
    }
    selectedErrorNode.add(errorModelIterator, newParentErrorModel);
  }

  public void accept(ErrorNodeVisitor errorNodeVisitor) {
    errorNodeVisitor.visit(this);
  }
}
