package org.mule.datasense.impl.util;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

import static java.util.Optional.empty;

public class ComponentModelUtils {

  public static Optional<Stream<ComponentModel>> collectComponentModels(MessageProcessorNode messageProcessorNode,
                                                                        Predicate<? super ComponentModel> childComponentFilter) {
    if (messageProcessorNode == null) {
      return empty();
    }
    final ComponentModel componentModel = messageProcessorNode.getComponentModel();
    if (componentModel == null) {
      return empty();
    }

    return Optional.of(componentModel.getInnerComponents().stream().filter(childComponentFilter));
  }

  public static Optional<Stream<ComponentModel>> collectComponentModelsById(MessageProcessorNode messageProcessorNode,
                                                                            ComponentIdentifier componentIdentifier) {
    if (componentIdentifier == null) {
      return empty();
    }
    return collectComponentModels(messageProcessorNode, componentModel -> componentIdentifier
        .equals(ComponentIdentifierUtils.createFromComponentModel(componentModel)));
  }

  public static Optional<ComponentModel> collectComponentModelById(MessageProcessorNode messageProcessorNode,
                                                                   ComponentIdentifier componentIdentifier) {
    return collectComponentModelsById(messageProcessorNode, componentIdentifier).flatMap(Stream::findFirst);
  }
}
