/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.reporting;

import org.apache.commons.lang3.StringUtils;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;

public class NotificationMessages {
    public static final String MSG_REQUIRED_PARAMETER_MISSING = "Required parameter missing";
    public static final String MSG_UNASSIGNABLE = "Unassignable";
    public static final String MSG_FAILED_TO_OBTAIN_METADATA = "Failed to obtain dynamic metadata resolving request [%s].";
    public static final String MSG_FAILED_TO_RESOLVE_FLOWREF = "Failed to solve flow-ref. Flow '%s' not found.";
    private static final String MSG_FAILED_TO_INFER_FLOW_OUTPUT_RECURSIVE_CALL_DETECTED = "Failed to infer output type on flow '%s'. It is required to define output type on flows with recursive calls.";
    private static final int MSG_EXPRESSION_ABBREVIATION = 80;

    public static final I18nMessage MSG_FAILED_TO_ENRICH_KEYS(MetadataFailure metadataFailure) {
        return I18nMessageFactory.createStaticMessage((String)metadataFailure.getMessage());
    }

    public static final I18nMessage REASON_FAILED_TO_ENRICH_KEYS(MetadataFailure metadataFailure) {
        return I18nMessageFactory.createStaticMessage((String)metadataFailure.getReason());
    }

    public static final I18nMessage MSG_FAILED_TO_RESOLVE_DYNAMIC_MODEL(MetadataFailure metadataFailure) {
        return I18nMessageFactory.createStaticMessage((String)metadataFailure.getMessage());
    }

    public static final I18nMessage REASON_FAILED_TO_RESOLVE_DYNAMIC_MODEL(MetadataFailure metadataFailure) {
        return I18nMessageFactory.createStaticMessage((String)metadataFailure.getReason());
    }

    private static String formatExpression(String expression) {
        return StringUtils.abbreviate((String)expression, (int)80);
    }

    public static final I18nMessage MSG_SCRIPTING_LANGUAGE_ERROR(String expression, String reason) {
        return I18nMessageFactory.createStaticMessage((String)"Scripting language error on expression '%s'. Reason: %s.", (Object[])new Object[]{NotificationMessages.formatExpression(expression), reason});
    }

    public static final I18nMessage MSG_SCRIPTING_LANGUAGE_WARNING(String expression, String reason) {
        return I18nMessageFactory.createStaticMessage((String)"Scripting language warning on expression '%s'. Reason: %s.", (Object[])new Object[]{NotificationMessages.formatExpression(expression), reason});
    }

    public static final I18nMessage MSG_RESOURCE_NOT_FOUND(String resource) {
        return I18nMessageFactory.createStaticMessage((String)"Resource '%s' not found.", (Object[])new Object[]{resource});
    }

    public static final I18nMessage MSG_UNKNOWN_FLOW_COMPONENT(MessageProcessorNode messageProcessorNode) {
        return I18nMessageFactory.createStaticMessage((String)"Unknown message processor %s. Datasense will use passthrough semantics.", (Object[])new Object[]{messageProcessorNode.getIdentifier()});
    }

    public static final I18nMessage MSG_RAML_RESOLUTION_NOTIFICATION(String notificationType, String message) {
        return I18nMessageFactory.createStaticMessage((String)"Raml resolution %s: %s.", (Object[])new Object[]{notificationType, message});
    }

    public static final I18nMessage MSG_SOAPKIT_RESOLUTION_NOTIFICATION(String notificationType, String message) {
        return I18nMessageFactory.createStaticMessage((String)"SoapKit resolution %s: %s.", (Object[])new Object[]{notificationType, message});
    }

    public static final I18nMessage MSG_RAML_RESOLUTION_INITIALIZATION(String message) {
        return I18nMessageFactory.createStaticMessage((String)"Raml resolution initialization failed. Error: %s.", (Object[])new Object[]{message});
    }

    public static final I18nMessage MSG_SOAPKIT_RESOLUTION_INITIALIZATION(String message) {
        return I18nMessageFactory.createStaticMessage((String)"SoapKit resolution initialization failed. Error: %s.", (Object[])new Object[]{message});
    }

    public static final I18nMessage MSG_RECURSIVE_CALL_DETECTED(String flow) {
        return I18nMessageFactory.createStaticMessage((String)MSG_FAILED_TO_INFER_FLOW_OUTPUT_RECURSIVE_CALL_DETECTED, (Object[])new Object[]{flow});
    }
}

