/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.ArrayList;
import java.util.Optional;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ProcessorChainTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.StructuralNodeTypeResolver;

public class ChoiceTypeResolver
extends StructuralNodeTypeResolver {
    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        ArrayList<EventType> nestedEventTypes = new ArrayList<EventType>();
        messageProcessorNode.getMessageProcessorNodes().forEach(pipedMessageProcessorNode -> nestedEventTypes.add(typingMuleAstVisitor.resolveType((AstNode)pipedMessageProcessorNode, inputEventType, typingMuleAstVisitorContext)));
        EventType outputEventType = TypeUtils.union(nestedEventTypes);
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));
        return outputEventType;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return false;
    }

    @Override
    protected boolean isSequential() {
        return false;
    }

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    public static class ChoiceOtherwiseTypeResolver
    extends ProcessorChainTypeResolver {
        @Override
        public Optional<ComponentModelType> getComponentModelType() {
            return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
        }
    }

    public static class ChoiceWhenTypeResolver
    extends ProcessorChainTypeResolver {
        @Override
        public Optional<ComponentModelType> getComponentModelType() {
            return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
        }
    }
}

