/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.StructuralNodeTypeResolver;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class ScatterGatherTypeResolver
extends StructuralNodeTypeResolver {
    private static final ComponentIdentifier COLLECT_LIST = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "collect-list");

    private boolean isCollectList(MessageProcessorNode scatterGatherMessageProcessorNode) {
        ComponentModel scatterGatherComponentModel = scatterGatherMessageProcessorNode.getComponentModel();
        for (ComponentModel childComponentModel : scatterGatherComponentModel.getInnerComponents()) {
            if (!COLLECT_LIST.equals(ComponentIdentifierUtils.createFromComponentModel(childComponentModel))) continue;
            return true;
        }
        return false;
    }

    private CollectStrategy resolveCollectStrategy(MessageProcessorNode scatterGatherMessageProcessorNode) {
        return this.isCollectList(scatterGatherMessageProcessorNode) ? new ListCollectStrategy() : new MapCollectStrategy();
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        CollectStrategy collectStrategy = this.resolveCollectStrategy(messageProcessorNode);
        ArrayList<EventType> nestedEventTypes = new ArrayList<EventType>();
        messageProcessorNode.getMessageProcessorNodes().forEach(pipedMessageProcessorNode -> {
            EventType nestedEventType = typingMuleAstVisitor.resolveType((AstNode)pipedMessageProcessorNode, inputEventType, typingMuleAstVisitorContext);
            nestedEventTypes.add(nestedEventType);
            collectStrategy.processMessageProcessorOutput((MessageProcessorNode)pipedMessageProcessorNode, nestedEventType);
        });
        EventType outputEventType = TypeUtils.merge(TypeUtils.union(nestedEventTypes), collectStrategy.build());
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));
        return outputEventType;
    }

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    @Override
    protected boolean isSequential() {
        return false;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }

    @Override
    protected boolean isScope() {
        return true;
    }

    private static class ListCollectStrategy
    extends BaseCollectStrategy {
        private List<MessageMetadataTypeBuilder> messageMetadataTypeBuilders;

        public ListCollectStrategy() {
            MessageMetadataTypeBuilder messageMetadataTypeBuilder = this.getMessageMetadataTypeBuilder();
            messageMetadataTypeBuilder.attributes().voidType();
            this.messageMetadataTypeBuilders = new ArrayList<MessageMetadataTypeBuilder>();
        }

        @Override
        public void processMessageProcessorOutput(MessageProcessorNode messageProcessorNode, EventType eventType) {
            MessageMetadataTypeBuilder routeMessageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
            MetadataType routePayloadMetadataType = (MetadataType)TypeUtils.getMessageMetadataType(eventType).flatMap(MessageMetadataType::getPayloadType).orElse(TypesHelper.getTypeBuilder().anyType().build());
            routeMessageMetadataTypeBuilder.payload(routePayloadMetadataType);
            TypeUtils.getMessageMetadataType(eventType).flatMap(MessageMetadataType::getAttributesType).ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)routeMessageMetadataTypeBuilder).attributes(arg_0));
            this.messageMetadataTypeBuilders.add(routeMessageMetadataTypeBuilder);
        }

        @Override
        protected void buildMessage() {
            BaseTypeBuilder elementTypeBuilder = TypesHelper.getTypeBuilder();
            if (this.messageMetadataTypeBuilders.isEmpty()) {
                elementTypeBuilder.anyType();
            } else {
                UnionTypeBuilder unionTypeBuilder = elementTypeBuilder.unionType();
                this.messageMetadataTypeBuilders.forEach(arg_0 -> ((UnionTypeBuilder)unionTypeBuilder).of(arg_0));
            }
            MessageMetadataTypeBuilder messageMetadataTypeBuilder = this.getMessageMetadataTypeBuilder();
            messageMetadataTypeBuilder.payload().arrayType().of((TypeBuilder)elementTypeBuilder);
        }
    }

    private static class MapCollectStrategy
    extends BaseCollectStrategy {
        private ObjectTypeBuilder objectTypeBuilder;

        public MapCollectStrategy() {
            MessageMetadataTypeBuilder messageMetadataTypeBuilder = this.getMessageMetadataTypeBuilder();
            this.objectTypeBuilder = messageMetadataTypeBuilder.payload().objectType();
            messageMetadataTypeBuilder.attributes().voidType();
        }

        @Override
        public void processMessageProcessorOutput(MessageProcessorNode messageProcessorNode, EventType eventType) {
            MessageMetadataTypeBuilder routeMessageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
            MetadataType routePayloadMetadataType = (MetadataType)TypeUtils.getMessageMetadataType(eventType).flatMap(MessageMetadataType::getPayloadType).orElse(TypesHelper.getTypeBuilder().anyType().build());
            TypeUtils.getMessageMetadataType(eventType).flatMap(MessageMetadataType::getAttributesType).ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)routeMessageMetadataTypeBuilder).attributes(arg_0));
            routeMessageMetadataTypeBuilder.payload(routePayloadMetadataType);
            DefaultComponentLocation defaultComponentLocation = messageProcessorNode.getComponentModel().getComponentLocation();
            LocationPart[] parts = defaultComponentLocation.getParts().toArray(new LocationPart[defaultComponentLocation.getParts().size()]);
            String routeId = this.buildRouteId(parts);
            this.objectTypeBuilder.addField().required().key(routeId).value((MetadataType)routeMessageMetadataTypeBuilder.build());
        }

        private String buildRouteId(LocationPart[] parts) {
            return parts[parts.length - 1].getPartPath();
        }
    }

    private static abstract class BaseCollectStrategy
    implements CollectStrategy {
        private MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();

        protected MessageMetadataTypeBuilder getMessageMetadataTypeBuilder() {
            return this.messageMetadataTypeBuilder;
        }

        protected void buildMessage() {
        }

        @Override
        public EventType build() {
            this.buildMessage();
            return new EventType(TypeUtils.asVarDecls(this.messageMetadataTypeBuilder.build()));
        }
    }

    private static interface CollectStrategy {
        public void processMessageProcessorOutput(MessageProcessorNode var1, EventType var2);

        public EventType build();
    }
}

