/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.MetadataTypeSubstitution;
import org.mule.datasense.impl.model.types.MetadataTypeUnification;
import org.mule.datasense.impl.model.types.TypeEquivalence;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.model.types.VarDeclMetadata;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.message.api.LocationAnnotation;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.message.Message;

public class TypeUtils {
    public static final Predicate<? super VarDecl> USE_EVENT_PREDICATE = varDecl -> !varDecl.getName().equals("#error#");

    public static boolean isAssignable(MetadataType sourceType, MetadataType targetType) {
        return TypeEquivalence.canBeAssignedTo(sourceType, targetType, null);
    }

    public static Stream<VarDecl> asVarDecls(MessageMetadataType messageMetadataType, boolean includeVoids) {
        HashSet varDecls = new HashSet();
        messageMetadataType.getPayloadType().filter(metadataType -> includeVoids || !(metadataType instanceof VoidType)).ifPresent(metadataType -> varDecls.add(new VarDecl("#payload#", (MetadataType)metadataType)));
        messageMetadataType.getAttributesType().filter(metadataType -> includeVoids || !(metadataType instanceof VoidType)).ifPresent(metadataType -> varDecls.add(new VarDecl("#attributes#", (MetadataType)metadataType)));
        return varDecls.stream();
    }

    public static Stream<VarDecl> asVarDecls(MessageMetadataType messageMetadataType) {
        return TypeUtils.asVarDecls(messageMetadataType, true);
    }

    public static Stream<VarDecl> asVarDecls(MuleEventMetadataType muleEventMetadataType) {
        HashSet varDecls = new HashSet();
        if (muleEventMetadataType != null) {
            varDecls.addAll(TypeUtils.asVarDecls(muleEventMetadataType.getMessageType()).collect(Collectors.toList()));
            muleEventMetadataType.getErrorType().ifPresent(metadataType -> varDecls.add(new VarDecl("#error#", (MetadataType)metadataType)));
            muleEventMetadataType.getVariables().getFields().forEach(objectFieldType -> varDecls.add(new VarDecl(objectFieldType.getKey().getName().getLocalPart(), objectFieldType.getValue())));
        }
        return varDecls.stream();
    }

    private static void enrichWithLocation(VarDecl dataDeclaration, Consumer<LocationAnnotation> locationAnnotationConsumer) {
        dataDeclaration.getMetadata().ifPresent(varDeclMetadata -> varDeclMetadata.getComponentLocation().ifPresent(componentLocation -> locationAnnotationConsumer.accept(new LocationAnnotation(componentLocation.getLocation()))));
    }

    public static MuleEventMetadataTypeBuilder asMuleEventMetadataType(EventType eventType) {
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = MuleEventMetadataType.builder();
        if (eventType.getVarDecls() != null) {
            eventType.getVarDecls().forEach(dataDeclaration -> {
                MetadataType metadataType = dataDeclaration.getType();
                Consumer<LocationAnnotation> locationAnnotationConsumer = null;
                if (dataDeclaration.getName().equals("#payload#")) {
                    muleEventMetadataTypeBuilder.message().payload(dataDeclaration.getType());
                    locationAnnotationConsumer = locationAnnotation -> muleEventMetadataTypeBuilder.message().withPayloadAnnotation((TypeAnnotation)locationAnnotation);
                } else if (dataDeclaration.getName().equals("#attributes#")) {
                    muleEventMetadataTypeBuilder.message().attributes(dataDeclaration.getType());
                    locationAnnotationConsumer = locationAnnotation -> muleEventMetadataTypeBuilder.message().withAttributesAnnotation((TypeAnnotation)locationAnnotation);
                } else if (dataDeclaration.getName().equals("#error#")) {
                    muleEventMetadataTypeBuilder.error(dataDeclaration.getType());
                } else {
                    ObjectFieldTypeBuilder variableField = muleEventMetadataTypeBuilder.addVariableField(dataDeclaration.getName());
                    variableField.value(metadataType);
                    locationAnnotationConsumer = locationAnnotation -> variableField.with((TypeAnnotation)locationAnnotation);
                }
                if (locationAnnotationConsumer != null) {
                    TypeUtils.enrichWithLocation(dataDeclaration, locationAnnotationConsumer);
                }
            });
        }
        return muleEventMetadataTypeBuilder;
    }

    public static EventType asEventType(MuleEventMetadataType muleEventMetadataType) {
        return new EventType(TypeUtils.asVarDecls(muleEventMetadataType));
    }

    public static EventType annotate(EventType eventType, VarDeclMetadata varDeclMetadata) {
        return new EventType(eventType.getVarDecls().map(varDecl -> new VarDecl(varDecl.getName(), varDecl.getType(), varDeclMetadata)));
    }

    public static EventType filter(EventType eventType, Predicate<? super VarDecl> predicate) {
        return new EventType(eventType.getVarDecls().filter(predicate));
    }

    public static EventType merge(EventType eventType1, EventType eventType2) {
        if (eventType1 == null) {
            return eventType2;
        }
        if (eventType2 == null) {
            return eventType1;
        }
        Set collect = eventType2.getVarDecls().collect(Collectors.toSet());
        collect.addAll(eventType1.getVarDecls().collect(Collectors.toSet()));
        return new EventType(collect.stream());
    }

    public static EventType minus(EventType eventType1, EventType eventType2) {
        if (eventType1 == null) {
            return null;
        }
        if (eventType2 == null) {
            return eventType1;
        }
        return new EventType(eventType1.getVarDecls().filter(varDecl -> !eventType2.get(varDecl.getName()).isPresent()));
    }

    public static MetadataType override(MetadataType metadataType1, MetadataType metadataType2) {
        MetadataType result;
        if (metadataType1 == null) {
            return metadataType2;
        }
        if (metadataType2 == null) {
            return metadataType1;
        }
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
        if (metadataType1 instanceof MessageMetadataType) {
            MessageMetadataType messageMetadataType1 = (MessageMetadataType)metadataType1;
            if (metadataType2 instanceof MessageMetadataType) {
                MetadataType attributesMetadataType;
                MessageMetadataType messageMetadataType2 = (MessageMetadataType)metadataType2;
                MetadataType payloadMetadataType = messageMetadataType2.getPayloadType().orElse(messageMetadataType1.getPayloadType().orElse(null));
                if (payloadMetadataType != null) {
                    messageMetadataTypeBuilder.payload(payloadMetadataType);
                }
                if ((attributesMetadataType = (MetadataType)messageMetadataType2.getAttributesType().orElse(messageMetadataType1.getAttributesType().orElse(null))) != null) {
                    messageMetadataTypeBuilder.attributes(attributesMetadataType);
                }
            } else {
                messageMetadataTypeBuilder.payload(metadataType2);
                messageMetadataType1.getAttributesType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)messageMetadataTypeBuilder).attributes(arg_0));
            }
            result = messageMetadataTypeBuilder.build();
        } else {
            result = metadataType2;
        }
        return result;
    }

    public static Optional<Map<String, MetadataType>> unifyTypes(MetadataType metadataType1, MetadataType metadataType2) {
        MetadataTypeUnification metadataTypeUnification = new MetadataTypeUnification();
        return metadataTypeUnification.unify(metadataType1, metadataType2);
    }

    public static MetadataType substitute(MetadataType metadataType, Map<String, MetadataType> substitution) {
        if (substitution == null || substitution.isEmpty()) {
            return metadataType;
        }
        MetadataTypeSubstitution metadataTypeSubstitution = new MetadataTypeSubstitution(substitution);
        return metadataTypeSubstitution.transform(metadataType);
    }

    public static EventType union(List<EventType> eventTypes) {
        if (eventTypes == null || eventTypes.size() == 0) {
            return new EventType();
        }
        HashMap metadataTypesByVar = new HashMap();
        HashMap metadataTypesCountByVar = new HashMap();
        eventTypes.forEach(eventType -> eventType.getVarDecls().forEach(varDecl -> {
            int count;
            LinkedHashSet<MetadataType> metadataTypes = (LinkedHashSet<MetadataType>)metadataTypesByVar.get(varDecl.getName());
            if (metadataTypes == null) {
                metadataTypes = new LinkedHashSet<MetadataType>();
                metadataTypesByVar.put(varDecl.getName(), metadataTypes);
                count = 0;
            } else {
                count = (Integer)metadataTypesCountByVar.get(varDecl.getName());
            }
            metadataTypes.add(varDecl.getType());
            metadataTypesCountByVar.put(varDecl.getName(), count + 1);
        }));
        ArrayList varDecls = new ArrayList();
        metadataTypesByVar.entrySet().forEach(stringListEntry -> {
            String varName = (String)stringListEntry.getKey();
            Set typeList = (Set)stringListEntry.getValue();
            Integer count = (Integer)metadataTypesCountByVar.get(varName);
            if (count > 0) {
                VarDecl varDecl = null;
                if (count < eventTypes.size()) {
                    typeList.add(TypesHelper.getTypeBuilder().nullType().build());
                }
                if (typeList.size() == 1) {
                    varDecl = new VarDecl(varName, (MetadataType)typeList.iterator().next());
                } else {
                    UnionTypeBuilder unionTypeBuilder = TypesHelper.getTypeBuilder().unionType();
                    typeList.forEach(arg_0 -> ((UnionTypeBuilder)unionTypeBuilder).of(arg_0));
                    varDecl = new VarDecl(varName, (MetadataType)unionTypeBuilder.build());
                }
                varDecls.add(varDecl);
            }
        });
        return new EventType(varDecls.stream());
    }

    public static EventType intersection(List<EventType> eventTypes) {
        if (eventTypes == null || eventTypes.size() == 0) {
            return new EventType();
        }
        HashMap metadataTypesByVar = new HashMap();
        eventTypes.forEach(eventType -> eventType.getVarDecls().forEach(varDecl -> {
            LinkedHashSet<MetadataType> metadataTypes = (LinkedHashSet<MetadataType>)metadataTypesByVar.get(varDecl.getName());
            if (metadataTypes == null) {
                metadataTypes = new LinkedHashSet<MetadataType>();
                metadataTypesByVar.put(varDecl.getName(), metadataTypes);
            }
            metadataTypes.add(varDecl.getType());
        }));
        ArrayList varDecls = new ArrayList();
        metadataTypesByVar.entrySet().forEach(stringListEntry -> {
            String varName = (String)stringListEntry.getKey();
            Set typeList = (Set)stringListEntry.getValue();
            if (typeList.size() > 0) {
                VarDecl varDecl = null;
                varDecl = typeList.size() == 1 ? new VarDecl(varName, (MetadataType)typeList.iterator().next()) : new VarDecl(varName, (MetadataType)TypesHelper.getTypeBuilder().anyType().build());
                varDecls.add(varDecl);
            }
        });
        return new EventType(varDecls.stream());
    }

    public static EventType override(EventType eventType1, EventType eventType2) {
        if (eventType1 == null) {
            return eventType2;
        }
        if (eventType2 == null) {
            return eventType1;
        }
        HashMap varDecls = new HashMap();
        eventType1.getVarDecls().forEach(varDecl -> varDecls.put(varDecl.getName(), varDecl));
        eventType2.getVarDecls().forEach(varDecl -> {
            VarDecl overridenVarDecl = (VarDecl)varDecls.get(varDecl.getName());
            if (overridenVarDecl != null) {
                varDecls.put(overridenVarDecl.getName(), new VarDecl(overridenVarDecl.getName(), TypeUtils.override(overridenVarDecl.getType(), varDecl.getType())));
            } else {
                varDecls.put(varDecl.getName(), varDecl);
            }
        });
        return new EventType(varDecls.values().stream());
    }

    public static EventType createEventType(MetadataType metadataType) {
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        if (metadataType != null) {
            muleEventMetadataTypeBuilder.message().payload(metadataType);
        }
        MuleEventMetadataType muleEventMetadataType = muleEventMetadataTypeBuilder.build();
        return TypeUtils.asEventType(muleEventMetadataType);
    }

    public static Optional<MetadataType> getMessagePayloadType(MetadataType metadataType) {
        if (metadataType == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metadataType instanceof MessageMetadataType ? (MetadataType)((MessageMetadataType)metadataType).getPayloadType().orElse(null) : null);
    }

    public static Optional<MetadataType> getMessageAttributesType(MetadataType metadataType) {
        if (metadataType == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metadataType instanceof MessageMetadataType ? (MetadataType)((MessageMetadataType)metadataType).getAttributesType().orElse(null) : null);
    }

    public static Optional<MessageMetadataType> getMessageMetadataType(EventType eventType) {
        if (eventType == null) {
            return Optional.empty();
        }
        VarDecl messagePayload = eventType.get("#payload#").orElse(null);
        VarDecl messageAttributes = eventType.get("#attributes#").orElse(null);
        if (messagePayload != null || messageAttributes != null) {
            MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
            eventType.get("#payload#").ifPresent(varDecl -> messageMetadataTypeBuilder.payload(varDecl.getType()));
            eventType.get("#attributes#").ifPresent(varDecl -> messageMetadataTypeBuilder.attributes(varDecl.getType()));
            return Optional.of(messageMetadataTypeBuilder.build());
        }
        return Optional.empty();
    }

    private static boolean isMessageMetadataType(MetadataType elementMetadataType) {
        return elementMetadataType.getAnnotation(TypeIdAnnotation.class).map(typeIdAnnotation -> Message.class.getName().equals(typeIdAnnotation.getValue())).orElse(false);
    }

    public static MessageMetadataType asMessageMetadataTypeOrEmptyMessage(MessageMetadataType messageMetadataType) {
        return TypeUtils.asMessageMetadataType((MetadataType)messageMetadataType).orElse(TypesHelper.getMessageMetadataTypeBuilder().build());
    }

    public static Optional<MessageMetadataType> asMessageMetadataType(MetadataType metadataType) {
        Optional<MessageMetadataType> result = Optional.empty();
        if (metadataType instanceof ObjectType && TypeUtils.isMessageMetadataType(metadataType)) {
            result = Optional.of(MessageMetadataType.builder((ObjectType)((ObjectType)metadataType))).map(MessageMetadataTypeBuilder::build);
        }
        return result;
    }

    public static Optional<MuleEventMetadataType> asMuleEventMetadataType(MetadataType metadataType) {
        Optional<MuleEventMetadataType> result = Optional.empty();
        if (metadataType instanceof ObjectType) {
            result = Optional.of(MuleEventMetadataType.builder((ObjectType)((ObjectType)metadataType))).map(MuleEventMetadataTypeBuilder::build);
        }
        return result;
    }

    public static TypeBindings buildTypeBindings(MuleEventMetadataType muleEventMetadataType, TypeBindings typeBindings) {
        TypeBindings.Builder builder = TypeBindings.builder();
        builder.addAll(typeBindings);
        builder.addAll(TypeBindings.builder((MuleEventMetadataType)muleEventMetadataType).build());
        return builder.build();
    }

    public static MetadataType removeNullsFromUnionMetadataType(MetadataType metadataType) {
        if (!(metadataType instanceof UnionType)) {
            return metadataType;
        }
        UnionType unionType = (UnionType)metadataType;
        List<MetadataType> metadataTypes = unionType.getTypes().stream().filter(elementMetadataType -> !(elementMetadataType instanceof NullType)).collect(Collectors.toList());
        if (metadataTypes.size() == 0) {
            return TypesHelper.getTypeBuilder().nullType().build();
        }
        if (metadataTypes.size() == 1) {
            return (MetadataType)metadataTypes.iterator().next();
        }
        UnionTypeBuilder unionTypeBuilder = TypesHelper.getTypeBuilder().unionType();
        metadataTypes.forEach(arg_0 -> ((UnionTypeBuilder)unionTypeBuilder).of(arg_0));
        return unionTypeBuilder.build();
    }
}

