/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.OperationCallAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.annotations.VoidOperationAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.annotators.BaseAnnotator;
import org.mule.datasense.impl.phases.annotators.OperationAnnotator;
import org.mule.datasense.impl.phases.annotators.SourceAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.message.api.MessageMetadataType;

public class OperationCallAnnotator
extends BaseAnnotator {
    private final SourceAnnotator sourceAnnotator = new SourceAnnotator();
    private final OperationAnnotator operationAnnotator = new OperationAnnotator();

    @Override
    public void annotate(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        if (!messageProcessorNode.isRootMessageProcessorNode() && !messageProcessorNode.getAnnotation(TypeResolverAnnotation.class).isPresent()) {
            messageProcessorNode.getComponentModelType().ifPresent(componentModelType -> {
                switch (componentModelType) {
                    case MESSAGE_PROCESSOR_NODE: {
                        this.operationAnnotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext);
                        break;
                    }
                    case MESSAGE_SOURCE_NODE: {
                        this.sourceAnnotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext);
                    }
                }
            });
            messageProcessorNode.getAnnotation(OperationCallBuilderAnnotation.class).ifPresent(operationCallBuilderAnnotation -> {
                OperationCallBuilder operationCallBuilder = operationCallBuilderAnnotation.getOperationCallBuilder();
                OperationCall operationCall = operationCallBuilder.build();
                if (this.isVoidOperation(operationCall)) {
                    messageProcessorNode.annotate(new VoidOperationAnnotation());
                }
                messageProcessorNode.annotate(new OperationCallAnnotation(operationCall));
                messageProcessorNode.annotate(new TypeResolverAnnotation(DefaultDataSense.COMPONENT_IDENTIFIER_OPERATION_CALL));
            });
        }
    }

    private boolean isVoidOperation(OperationCall operationCall) {
        boolean result = false;
        MetadataType returnType = operationCall.getReturnType();
        if (returnType instanceof MessageMetadataType) {
            MessageMetadataType messageMetadataType = (MessageMetadataType)returnType;
            result = !(messageMetadataType.getPayloadType().isPresent() && !(messageMetadataType.getPayloadType().get() instanceof VoidType) || messageMetadataType.getAttributesType().isPresent() && !(messageMetadataType.getAttributesType().get() instanceof VoidType));
        }
        return result;
    }
}

