/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.transform;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

public class TransformParser {
    static final ComponentIdentifier MESSAGE = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "message");
    static final ComponentIdentifier VARIABLES = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "variables");
    static final ComponentIdentifier SET_PAYLOAD = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "set-payload");
    static final ComponentIdentifier SET_ATTRIBUTES = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "set-attributes");
    static final ComponentIdentifier SET_VARIABLE = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "set-variable");
    static final String ATTR_VARIABLE_NAME = "variableName";
    static final String ATTR_RESOURCE = "resource";

    private Optional<String> findResourceExpression(String resource, TransformParserContext transformParserContext) {
        return transformParserContext.getResourceResolver().map(resourceResolver -> ((Optional)resourceResolver.apply(resource)).map(uri -> {
            try {
                return FileUtils.readFileToString((File)FileUtils.toFile((URL)uri.toURL()));
            }
            catch (Exception e) {
                transformParserContext.getAstNotification().ifPresent(astNotification -> astNotification.reportError(transformParserContext.getAstNodeLocation().orElse(null), NotificationMessages.MSG_RESOURCE_NOT_FOUND(resource)));
                return null;
            }
        })).orElse(Optional.empty());
    }

    private Optional<String> findExpression(ComponentModel componentModel, TransformParserContext transformParserContext) {
        return Optional.ofNullable(componentModel.getParameters().get(ATTR_RESOURCE)).map(resource -> this.findResourceExpression((String)resource, transformParserContext)).orElse(Optional.ofNullable(componentModel.getTextContent()));
    }

    public void parseMessage(ComponentModel componentModel, MuleEventExprBuilder muleEventExprBuilder, TransformParserContext transformParserContext) {
        componentModel.getInnerComponents().forEach(childComponentModel -> {
            ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(childComponentModel);
            if (SET_PAYLOAD.equals(componentIdentifier)) {
                this.findExpression((ComponentModel)childComponentModel, transformParserContext).ifPresent(expression -> muleEventExprBuilder.message(m -> m.value(m1 -> m1.payload(new SimpleExprBuilder((String)expression)))));
            } else if (SET_ATTRIBUTES.equals(componentIdentifier)) {
                this.findExpression((ComponentModel)childComponentModel, transformParserContext).ifPresent(expression -> muleEventExprBuilder.message(m -> m.value(m1 -> m1.attributes(new SimpleExprBuilder((String)expression)))));
            }
        });
    }

    public void parseVariables(ComponentModel componentModel, MuleEventExprBuilder muleEventExprBuilder, TransformParserContext transformParserContext) {
        componentModel.getInnerComponents().forEach(childComponentModel -> {
            ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(childComponentModel);
            if (SET_VARIABLE.equals(componentIdentifier)) {
                Optional.ofNullable(childComponentModel.getParameters().get(ATTR_VARIABLE_NAME)).ifPresent(name -> this.findExpression((ComponentModel)childComponentModel, transformParserContext).ifPresent(expression -> muleEventExprBuilder.variable((String)name, v -> v.value(new ValueExprBuilder(new SimpleExprBuilder((String)expression))))));
            }
        });
    }

    public MuleEventExprBuilder parse(ComponentModel transformComponentModel, TransformParserContext transformParserContext) {
        MuleEventExprBuilder muleEventExprBuilder = new MuleEventExprBuilder();
        transformComponentModel.getInnerComponents().forEach(componentModel -> {
            ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(componentModel);
            if (MESSAGE.equals(componentIdentifier)) {
                this.parseMessage((ComponentModel)componentModel, muleEventExprBuilder, transformParserContext);
            } else if (VARIABLES.equals(componentIdentifier)) {
                this.parseVariables((ComponentModel)componentModel, muleEventExprBuilder, transformParserContext);
            }
        });
        return muleEventExprBuilder;
    }

    public MuleEventExprBuilder parse(ComponentModel transformComponentModel, Function<String, Optional<URI>> resourceResolver, AstNotification astNotification, AstNodeLocation astNodeLocation) {
        return this.parse(transformComponentModel, new TransformParserContext(resourceResolver, astNotification, astNodeLocation));
    }

    public MuleEventExprBuilder parse(ComponentModel transformComponentModel) {
        return this.parse(transformComponentModel, null, null, null);
    }

    private static class TransformParserContext {
        private final Function<String, Optional<URI>> resourceResolver;
        private final AstNotification astNotification;
        private final AstNodeLocation astNodeLocation;

        public TransformParserContext(Function<String, Optional<URI>> resourceResolver, AstNotification astNotification, AstNodeLocation astNodeLocation) {
            this.resourceResolver = resourceResolver;
            this.astNotification = astNotification;
            this.astNodeLocation = astNodeLocation;
        }

        public Optional<Function<String, Optional<URI>>> getResourceResolver() {
            return Optional.ofNullable(this.resourceResolver);
        }

        public Optional<AstNotification> getAstNotification() {
            return Optional.ofNullable(this.astNotification);
        }

        public Optional<AstNodeLocation> getAstNodeLocation() {
            return Optional.ofNullable(this.astNodeLocation);
        }
    }
}

