/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.annotators.BaseOperationCallBuilderAnnotator;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.datasense.impl.util.extension.DslElementModelVisitor;
import org.mule.datasense.impl.util.extension.DslElementModelWalker;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;

public abstract class StaticDslBaseAnnotator
extends BaseOperationCallBuilderAnnotator {

    protected static class OperationCallDslElementModelVisitor
    implements DslElementModelVisitor {
        private final OperationCallBuilder operationCallBuilder;
        private boolean hasDynamicType;
        private List<ParameterModel> incompleteForDynamicMetadata;

        public OperationCallDslElementModelVisitor(OperationCallBuilder operationCallBuilder) {
            this.operationCallBuilder = operationCallBuilder;
            this.hasDynamicType = false;
            this.incompleteForDynamicMetadata = new ArrayList<ParameterModel>();
        }

        @Override
        public void visitOperationModel(DslElementModel<OperationModel> operationModelDslElementModel, DslElementModelWalker dslElementModelWalker) {
            OperationModel model = (OperationModel)operationModelDslElementModel.getModel();
            this.operationCallBuilder.name(model.getName());
            operationModelDslElementModel.getContainedElements().forEach(dslElementModel -> dslElementModelWalker.walkDslElementModel((DslElementModel)dslElementModel, this));
            this.operationCallBuilder.errors(model.getErrorModels());
            this.operationCallBuilder.returnType((MetadataType)TypesHelper.getMessageMetadataTypeBuilder().payload(model.getOutput().getType()).attributes(model.getOutputAttributes().getType()).build());
            this.hasDynamicType |= model.getOutput().hasDynamicType() || model.getOutputAttributes().hasDynamicType();
            if (this.hasDynamicType) {
                this.incompleteForDynamicMetadata = OperationCallDslElementModelVisitor.incompleteForDynamicMetadata(this.operationCallBuilder, (ParameterizedModel)model);
            }
        }

        private static List<ParameterModel> incompleteForDynamicMetadata(OperationCallBuilder operationCallBuilder, ParameterizedModel parameterizedModel) {
            ArrayList<ParameterModel> incompleteParameters = new ArrayList<ParameterModel>();
            if (operationCallBuilder != null) {
                OperationCall operationCall = operationCallBuilder.build();
                List allParameterModels = parameterizedModel.getAllParameterModels();
                if (allParameterModels != null) {
                    for (ParameterModel parameterModel : allParameterModels) {
                        MetadataKeyPartModelProperty metadataKeyPartModelProperty = parameterModel.getModelProperty(MetadataKeyPartModelProperty.class).orElse(null);
                        if (metadataKeyPartModelProperty == null || operationCall.getInputMapping(parameterModel.getName()).isPresent()) continue;
                        incompleteParameters.add(parameterModel);
                    }
                }
            }
            return incompleteParameters;
        }

        @Override
        public void visitSourceModel(DslElementModel<SourceModel> sourceModelDslElementModel, DslElementModelWalker dslElementModelWalker) {
            SourceModel model = (SourceModel)sourceModelDslElementModel.getModel();
            this.operationCallBuilder.name(model.getName());
            sourceModelDslElementModel.getContainedElements().forEach(dslElementModel -> dslElementModelWalker.walkDslElementModel((DslElementModel)dslElementModel, this));
            this.operationCallBuilder.errors(model.getErrorModels());
            this.operationCallBuilder.returnType((MetadataType)TypesHelper.getMessageMetadataTypeBuilder().payload(model.getOutput().getType()).attributes(model.getOutputAttributes().getType()).build());
            this.hasDynamicType |= model.getOutput().hasDynamicType() || model.getOutputAttributes().hasDynamicType();
            this.incompleteForDynamicMetadata = OperationCallDslElementModelVisitor.incompleteForDynamicMetadata(this.operationCallBuilder, (ParameterizedModel)model);
        }

        private void addParameter(String name, MetadataType metadataType, String value) {
            this.operationCallBuilder.input(inputMappingBuilder -> inputMappingBuilder.parameter(inputParameterBuilder -> inputParameterBuilder.name(name).type(metadataType)).argument(inputArgumentBuilder -> {
                ExpressionLanguageUtils.extractExpression(value).ifPresent(inputArgumentBuilder::expression);
                inputArgumentBuilder.value(value);
            }));
        }

        @Override
        public void visitParameterGroupModel(DslElementModel<ParameterGroupModel> parameterGroupModelDslElementModel, DslElementModelWalker dslElementModelWalker) {
            parameterGroupModelDslElementModel.getContainedElements().forEach(dslElementModel -> dslElementModelWalker.walkDslElementModel((DslElementModel)dslElementModel, this));
        }

        @Override
        public void visitParameterModel(DslElementModel<ParameterModel> parameterModelDslElementModel, DslElementModelWalker dslElementModelWalker) {
            ParameterModel parameterModel = (ParameterModel)parameterModelDslElementModel.getModel();
            this.hasDynamicType |= parameterModel.hasDynamicType();
            Optional valueOptional = parameterModelDslElementModel.getValue();
            if (valueOptional.isPresent()) {
                this.addParameter(parameterModel.getName(), parameterModel.getType(), (String)valueOptional.get());
            } else {
                parameterModelDslElementModel.getContainedElements().forEach(dslElementModel -> dslElementModelWalker.walkDslElementModel((DslElementModel)dslElementModel, this));
            }
        }

        @Override
        public void visitMetadataType(DslElementModel<MetadataType> metadataTypeDslElementModel, DslElementModelWalker dslElementModelWalker) {
            MetadataType model = (MetadataType)metadataTypeDslElementModel.getModel();
            Optional valueOptional = metadataTypeDslElementModel.getValue();
            if (valueOptional.isPresent()) {
                MetadataType type = model instanceof ObjectFieldType ? ((ObjectFieldType)model).getValue() : model;
                this.addParameter(metadataTypeDslElementModel.getIdentifier().map(componentIdentifier -> componentIdentifier.getName()).orElse(""), type, (String)valueOptional.get());
            } else {
                metadataTypeDslElementModel.getContainedElements().forEach(dslElementModel -> dslElementModelWalker.walkDslElementModel((DslElementModel)dslElementModel, this));
            }
        }

        public boolean isHasDynamicType() {
            return this.hasDynamicType;
        }

        public Collection<ParameterModel> isIncompleteForDynamicMetadata() {
            return this.incompleteForDynamicMetadata;
        }
    }
}

