/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Set;
import java.util.stream.Collectors;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallAnnotation;
import org.mule.datasense.impl.model.annotations.ThrowsErrorsTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.VoidOperationAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.InputArgument;
import org.mule.datasense.impl.model.operation.InputParameter;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TargetProcessingSupport;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMappingUtils;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.datasense.impl.util.MessageCallbackFactory;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class OperationCallTypeResolver
extends SingleNodeTypeResolver {
    private final TargetProcessingSupport targetProcessingSupport = new TargetProcessingSupport();

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        MetadataType returnType;
        OperationCallAnnotation operationCallAnnotation = (OperationCallAnnotation)messageProcessorNode.getAnnotation(OperationCallAnnotation.class).orElseThrow(() -> new RuntimeException("Operation call annotation not present"));
        OperationCall operationCall = operationCallAnnotation.getOperationCall();
        MuleEventMetadataTypeBuilder inferredMuleEventTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver = visitorContext.getExpressionLanguageMetadataTypeResolver();
        MessageCallbackFactory messageCallbackFactory = this.createMessageCallbackFactory(visitorContext.getAstNotification(), messageProcessorNode.getAstNodeLocation());
        operationCall.getInputMappings().forEach(inputMapping -> {
            InputArgument inputArgument = inputMapping.getInputArgument();
            InputParameter inputParameter = inputMapping.getInputParameter();
            if (inputArgument.getExpression() != null) {
                ExpressionLanguageUtils.resolveInputEventType(inputArgument.getExpression(), expressionLanguageMetadataTypeResolver, inputParameter.getMetadataType(), inferredMuleEventTypeBuilder, messageCallbackFactory.createMessageCallback(inputArgument.getExpression()));
            }
        });
        MuleEventMetadataType inferredInputMuleEventType = inferredMuleEventTypeBuilder.build();
        messageProcessorNode.annotate(new UsesTypeAnnotation(TypeUtils.asEventType(inferredInputMuleEventType)));
        messageProcessorNode.annotate(new ThrowsErrorsTypeAnnotation(this.resolveThrownErrors(operationCall, messageProcessorNode)));
        EventType outputEventType = inputEventType;
        if (!messageProcessorNode.isAnnotatedWith(VoidOperationAnnotation.class) && (returnType = operationCall.getReturnType()) instanceof MessageMetadataType) {
            MessageMetadataType returnMessageMetadataType = (MessageMetadataType)returnType;
            outputEventType = this.targetProcessingSupport.processTarget((String)operationCall.getTarget().orElse(null), operationCall.getTargetValueExpression(), operationCall.getOutputMimeType(), TypesHelper.getMuleEventMetadataTypeBuilder().message(returnMessageMetadataType).build(), visitorContext, messageCallbackFactory);
            messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));
        }
        return outputEventType;
    }

    private Set<ErrorModel> resolveThrownErrors(OperationCall operationCall, MessageProcessorNode messageProcessorNode) {
        Set<ErrorModel> errorModels = operationCall.getErrorModels();
        return ErrorMappingUtils.createErrorMapper(messageProcessorNode).map(errorMapper -> errorModels.stream().map(errorMapper::map).collect(Collectors.toSet())).orElse(errorModels);
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }
}

