/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingContext;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMatcher;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class ErrorHandlingEnvironment {
    private Deque<ErrorHandlingContext> errorHandlingContexts = new ArrayDeque<ErrorHandlingContext>();

    public void pushContext(String id) {
        this.errorHandlingContexts.push(new ErrorHandlingContext(id));
    }

    public void popContext() {
        ErrorHandlingContext errorHandlingContext = this.errorHandlingContexts.pop();
        if (!this.errorHandlingContexts.isEmpty()) {
            this.throwErrors(errorHandlingContext.getUnhandledErrors());
        }
    }

    public ErrorHandlingContext getContext() {
        return this.errorHandlingContexts.peek();
    }

    public void enterErrorHandling() {
        this.getContext().close();
    }

    private ErrorHandlingContext findOpenContext() {
        for (ErrorHandlingContext errorHandlingContext : this.errorHandlingContexts) {
            if (!errorHandlingContext.isOpen()) continue;
            return errorHandlingContext;
        }
        throw new IllegalStateException();
    }

    public void throwErrors(Set<ErrorModel> errorModels) {
        this.findOpenContext().union(errorModels);
    }

    public void handleErrors(ErrorMatcher errorMatcher) {
        this.getContext().handle(errorMatcher);
    }
}

