/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.util.MessageCallbackFactory;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;

public class AstMessageCallbackFactory
implements MessageCallbackFactory {
    private final AstNotification astNotification;
    private final AstNodeLocation astNodeLocation;

    public AstMessageCallbackFactory(AstNotification astNotification, AstNodeLocation astNodeLocation) {
        Preconditions.checkNotNull((Object)astNotification);
        Preconditions.checkNotNull((Object)astNodeLocation);
        this.astNotification = astNotification;
        this.astNodeLocation = astNodeLocation;
    }

    @Override
    public ExpressionLanguageMetadataTypeResolver.MessageCallback createMessageCallback(final String expression) {
        return new ExpressionLanguageMetadataTypeResolver.MessageCallback(){

            public void warning(String message, ExpressionLanguageMetadataTypeResolver.MessageLocation messageLocation) {
                AstMessageCallbackFactory.this.astNotification.reportWarning(AstMessageCallbackFactory.this.astNodeLocation, NotificationMessages.MSG_SCRIPTING_LANGUAGE_WARNING(expression, message));
            }

            public void error(String message, ExpressionLanguageMetadataTypeResolver.MessageLocation messageLocation) {
                AstMessageCallbackFactory.this.astNotification.reportError(AstMessageCallbackFactory.this.astNodeLocation, NotificationMessages.MSG_SCRIPTING_LANGUAGE_ERROR(expression, message));
            }
        };
    }
}

