/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import java.util.Optional;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;
import org.mule.metadata.message.api.el.TypeBindings;

public class ExpressionLanguageUtils {
    public static final String EXPRESSION_PREFIX = "#[";
    public static final String EXPRESSION_PREFIX_MEL = "#[mel:";
    public static final String EXPRESSION_POSTFIX = "]";

    public static boolean isExpression(String value) {
        return ExpressionLanguageUtils.extractExpression(value).isPresent();
    }

    public static Optional<String> extractExpression(String value) {
        String trimmedText;
        Optional<String> result = Optional.empty();
        if (value != null && !value.isEmpty() && (trimmedText = value.trim()).startsWith(EXPRESSION_PREFIX) && !trimmedText.startsWith(EXPRESSION_PREFIX_MEL) && trimmedText.endsWith(EXPRESSION_POSTFIX)) {
            result = Optional.of(trimmedText.substring(EXPRESSION_PREFIX.length(), trimmedText.length() - EXPRESSION_POSTFIX.length()));
        }
        return result;
    }

    public static String toExpression(String expression) {
        return EXPRESSION_PREFIX + expression + EXPRESSION_POSTFIX;
    }

    public static MetadataType resolveExpressionType(String expression, MuleEventMetadataType muleEventMetadataType, TypeBindings typeBindings, ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver, ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback) {
        return expressionLanguageMetadataTypeResolver.getOutputType(TypeUtils.buildTypeBindings(muleEventMetadataType, typeBindings), expression, messageCallback);
    }

    public static MetadataType resolveExpressionType(String expression, String mimeType, MuleEventMetadataType muleEventMetadataType, TypeBindings typeBindings, ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver, ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback) {
        return expressionLanguageMetadataTypeResolver.getOutputType(TypeUtils.buildTypeBindings(muleEventMetadataType, typeBindings), expression, mimeType, messageCallback);
    }

    public static MetadataType resolveExpressionType(String expression, EventType inputEventType, TypeBindings typeBindings, ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver, ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback) {
        return ExpressionLanguageUtils.resolveExpressionType(expression, TypeUtils.asMuleEventMetadataType(inputEventType).build(), typeBindings, expressionLanguageMetadataTypeResolver, messageCallback);
    }

    public static void resolveInputEventType(String expression, ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver, MetadataType metadataType, MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder, ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback) {
        expressionLanguageMetadataTypeResolver.getInputType(expression, metadataType, muleEventMetadataTypeBuilder, messageCallback);
    }
}

