package org.mule.datasense.impl.model.event;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Optional;

public class LiteralValueExpr implements Expr {

  private final String value;
  private final String mimeType;

  public LiteralValueExpr(String value, String mimeType) {
    Preconditions.checkNotNull(value);
    this.value = value;
    this.mimeType = mimeType;
  }

  private Optional<String> getMimeType() {
    return Optional.ofNullable(mimeType);
  }

  private boolean isMimeTypeApplicationJava(String mimeType) {
    for (String applicationJavaValidMimeType : MetadataFormats.JAVA.getValidMimeTypes()) {
      if (mimeType.startsWith(applicationJavaValidMimeType)) {
        return true;
      }
    }
    return false;
  }

  @Override
  public MetadataType resolveType(MuleEventMetadataType muleEventMetadataType,
                                  ResolveTypeContext resolveTypeContext) {
    MetadataType result;

    final String mimeType = getMimeType().orElse(null);
    final BaseTypeBuilder typeBuilder = TypesHelper.getTypeBuilder();
    if (mimeType == null || isMimeTypeApplicationJava(mimeType)) {
      result = typeBuilder.stringType().build();
    } else {
      final ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver =
          resolveTypeContext.getExpressionLanguageMetadataTypeResolver();
      result = null;
      try {
        result = expressionLanguageMetadataTypeResolver.getMetadataFromSample(new ByteArrayInputStream(value.getBytes()),
                                                                              Collections.emptyMap(), getMimeType().orElse(null));
      } catch (Exception e) {
      }
      if (result == null) {
        result = typeBuilder.anyType().build();
      }
    }
    return result;
  }

  @Override
  public void resolveInputType(MetadataType metadataType, MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                               ResolveTypeContext resolveTypeContext) {}

}
