package org.mule.datasense.impl.model.event;

import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

import com.google.common.base.Preconditions;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;
import org.mule.metadata.message.api.el.TypeBindings;

import java.util.Optional;

public class SimpleExpr implements Expr {

  private final String expression;
  private final String mimeType;

  public SimpleExpr(String expression, String mimeType) {
    Preconditions.checkNotNull(expression);
    this.expression = expression;
    this.mimeType = mimeType;
  }

  private Optional<String> getMimeType() {
    return Optional.ofNullable(mimeType);
  }

  @Override
  public MetadataType resolveType(MuleEventMetadataType muleEventMetadataType,
                                  ResolveTypeContext resolveTypeContext) {
    final TypeBindings typeBindings = TypeUtils.buildTypeBindings(muleEventMetadataType,
                                                                  resolveTypeContext
                                                                      .getTypeBindings());
    final ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback = resolveTypeContext.getMessageCallbackFactory()
        .createMessageCallback(expression);
    return getMimeType()
        .map(mimeType -> resolveTypeContext.getExpressionLanguageMetadataTypeResolver().getOutputType(typeBindings, expression,
                                                                                                      mimeType, messageCallback))
        .orElse(resolveTypeContext.getExpressionLanguageMetadataTypeResolver().getOutputType(typeBindings, expression,
                                                                                             messageCallback));
  }

  @Override
  public void resolveInputType(MetadataType metadataType, MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                               ResolveTypeContext resolveTypeContext) {
    resolveTypeContext.getExpressionLanguageMetadataTypeResolver()
        .getInputType(expression, metadataType, muleEventMetadataTypeBuilder,
                      resolveTypeContext.getMessageCallbackFactory().createMessageCallback(expression));
  }

}
