package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.HasDynamicMetadataAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.datasense.impl.util.MutableHolder;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.api.component.ComponentIdentifier;

import java.util.Optional;

public abstract class BaseExtensionAnnotator extends BaseOperationCallBuilderAnnotator {

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    ComponentModel componentModel = messageProcessorNode.getComponentModel();
    annotatingMuleAstVisitorContext.getAnnotation(MuleFlowAnnotation.class).ifPresent(muleFlowAnnotation -> {
      resolveComponentModel(messageProcessorNode, annotatingMuleAstVisitorContext,
                            annotatingMuleAstVisitorContext.getDataSenseProviderResolver(), componentModel)
                                .ifPresent(metaComponentModel -> {
                                  MutableHolder<Boolean> hasDynamicTypeHolder = new MutableHolder<Boolean>(Boolean.FALSE);

                                  annotatingMuleAstVisitorContext.logger()
                                      .debug("resolved model: " + metaComponentModel.getName());
                                  OperationCallBuilder operationCallBuilder =
                                      messageProcessorNode
                                          .getOrCreateAnnotation(OperationCallBuilderAnnotation.class,
                                                                 OperationCallBuilderAnnotation::new)
                                          .getOperationCallBuilder();
                                  operationCallBuilder
                                      .name(metaComponentModel.getName());

                                  metaComponentModel.getAllParameterModels().stream()
                                      .filter(parameterModel -> !"config-ref".equals(parameterModel.getName()))
                                      .forEach(parameterModel -> {
                                        hasDynamicTypeHolder
                                            .setValue(hasDynamicTypeHolder.getValue().orElse(false)
                                                || parameterModel.hasDynamicType());
                                        operationCallBuilder.input(parameterModel.getName(), inputMappingBuilder -> {
                                          inputMappingBuilder
                                              .parameter(inputParameterBuilder -> {
                                                inputParameterBuilder
                                                    .name(parameterModel.getName())
                                                    .type(parameterModel.getType());
                                              });
                                        });
                                      });

                                  boolean hasDynamicType = hasDynamicTypeHolder.getValue().orElse(false);

                                  if (metaComponentModel instanceof HasOutputModel) {
                                    HasOutputModel hasOutputModel = (HasOutputModel) metaComponentModel;
                                    operationCallBuilder.returnType(TypesHelper.getMessageMetadataTypeBuilder()
                                        .payload(hasOutputModel.getOutput().getType())
                                        .attributes(hasOutputModel.getOutputAttributes().getType()).build());
                                    hasDynamicType = hasDynamicType || hasOutputModel.getOutput().hasDynamicType()
                                        || hasOutputModel.getOutputAttributes().hasDynamicType();
                                  }

                                  annotatingMuleAstVisitorContext.logger()
                                      .debug(String.format("component model: %s, hasDynamicType: %s",
                                                           metaComponentModel.getName(), hasDynamicType));
                                  if (hasDynamicType) {
                                    messageProcessorNode.annotate(new HasDynamicMetadataAnnotation());
                                  }
                                });
    });
  }

  protected abstract Optional<org.mule.runtime.api.meta.model.ComponentModel> resolveComponentModel(
                                                                                                    MessageProcessorNode messageProcessorNode,
                                                                                                    AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext,
                                                                                                    DataSenseProviderResolver dataSenseProviderResolver,
                                                                                                    ComponentModel componentModel);


}
