package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.metadata.OperationModelAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.config.internal.model.ComponentModel;

import java.util.Optional;

public class StaticOperationAnnotator extends BaseStaticAnnotator {

  @Override
  protected Optional<org.mule.runtime.api.meta.model.ComponentModel> resolveComponentModel(
                                                                                           MessageProcessorNode messageProcessorNode,
                                                                                           AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext,
                                                                                           DataSenseProviderResolver dataSenseProviderResolver,
                                                                                           ComponentModel componentModel) {
    return dataSenseProviderResolver.resolveOperationModel(componentModel)
        .map(operationModel -> {
          messageProcessorNode.annotate(new OperationModelAnnotation(operationModel));
          return (org.mule.runtime.api.meta.model.ComponentModel) operationModel;
        });
  }
}
