package org.mule.datasense.impl.phases.builder;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.metadata.api.model.FunctionType;
import org.mule.runtime.config.internal.model.ComponentModel;import org.mule.runtime.api.component.ComponentIdentifier;;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MessageProcessorNodeBuilder implements AstNodeBuilder<MessageProcessorNode> {

  private final ComponentIdentifier componentIdentifier;
  private ComponentModelType componentModelType;
  private ComponentModel componentModel;
  private List<MessageProcessorNodeBuilder> messageProcessorNodeBuilderList;
  private FunctionType declaredFunctionType;
  private boolean rootMessageProcessorNode;
  private boolean synthetic;

  public MessageProcessorNodeBuilder(ComponentIdentifier componentIdentifier) {
    this.componentIdentifier = componentIdentifier;
    this.componentModel = null;
    this.declaredFunctionType = null;
    this.componentModelType = null;
    messageProcessorNodeBuilderList = new ArrayList<>();
  }

  public MessageProcessorNodeBuilder(String componentIdentifier) {
    this(ComponentIdentifier.buildFromStringRepresentation(componentIdentifier));
  }

  public MessageProcessorNodeBuilder messageProcessor(MessageProcessorNodeBuilder messageProcessorNodeBuilder) {
    messageProcessorNodeBuilderList.add(messageProcessorNodeBuilder);
    return this;
  }

  public MessageProcessorNodeBuilder messageProcessor(String componentIdentifier,
                                                      Consumer<MessageProcessorNodeBuilder> messageProcessorNodeBuilderConsumer) {
    return messageProcessor(ComponentIdentifier.buildFromStringRepresentation(componentIdentifier),
                            messageProcessorNodeBuilderConsumer);
  }

  public MessageProcessorNodeBuilder messageProcessor(ComponentIdentifier componentIdentifier,
                                                      Consumer<MessageProcessorNodeBuilder> messageProcessorNodeBuilderConsumer) {
    MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
    messageProcessorNodeBuilderList.add(messageProcessorNodeBuilder);
    if (messageProcessorNodeBuilderConsumer != null) {
      messageProcessorNodeBuilderConsumer.accept(messageProcessorNodeBuilder);
    }
    return this;
  }

  public MessageProcessorNodeBuilder messageProcessor(String componentIdentifier) {
    return messageProcessor(componentIdentifier, null);
  }

  public MessageProcessorNodeBuilder declaredFunctionType(FunctionType functionType) {
    this.declaredFunctionType = functionType;
    return this;
  }

  public MessageProcessorNodeBuilder config(ComponentModel componentModel) {
    this.componentModel = componentModel;
    return this;
  }

  public MessageProcessorNodeBuilder componentModelType(ComponentModelType componentModelType) {
    this.componentModelType = componentModelType;
    return this;
  }

  public MessageProcessorNodeBuilder root() {
    this.rootMessageProcessorNode = true;
    return this;
  }

  public MessageProcessorNodeBuilder synthetic() {
    this.synthetic = true;
    return this;
  }

  public ComponentIdentifier getComponentIdentifier() {
    return componentIdentifier;
  }

  public List<MessageProcessorNodeBuilder> getMessageProcessorNodeBuilderList() {
    return messageProcessorNodeBuilderList;
  }

  public MessageProcessorNode build() {
    List<MessageProcessorNode> children = messageProcessorNodeBuilderList.stream().map(
                                                                                       MessageProcessorNodeBuilder::build)
        .collect(
                 Collectors.toList());
    MessageProcessorNode messageProcessorNode =
        new MessageProcessorNode(componentIdentifier, componentModel, children, declaredFunctionType, componentModelType,
                                 synthetic);
    children.forEach(child -> child.setParentAstNode(messageProcessorNode));
    messageProcessorNode.setRootMessageProcessorNode(rootMessageProcessorNode);
    return messageProcessorNode;
  }
}
