package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import static org.mule.datasense.impl.phases.builder.MuleAstParser.MULE_CORE;

public class ErrorMappingUtils {

  private static final ComponentIdentifier ERROR_MAPPING =
      ComponentIdentifierUtils.createFromNamespaceAndName(MULE_CORE, "error-mapping");
  private static final String ATTR_SOURCE_TYPE = "sourceType";
  private static final String ATTR_TARGET_TYPE = "targetType";

  public static Optional<ErrorMapping> createErrorMapping(ComponentModel componentModel) {
    if (!ERROR_MAPPING.equals(ComponentIdentifierUtils.createFromComponentModel(componentModel))) {
      return Optional.empty();
    }

    final Map<String, String> parameters = componentModel.getParameters();
    return ErrorMapping.create(parameters.get(ATTR_SOURCE_TYPE), parameters.get(ATTR_TARGET_TYPE));
  }

  public static Optional<ErrorMapper> createErrorMapper(MessageProcessorNode messageProcessorNode) {
    List<ErrorMapping> errorMappings = new ArrayList<>();
    Optional.ofNullable(messageProcessorNode.getComponentModel()).ifPresent(componentModel -> {
      componentModel.getInnerComponents().forEach(childComponentModel -> {
        ErrorMappingUtils.createErrorMapping(childComponentModel).ifPresent(errorMappings::add);
      });
    });
    return Optional.ofNullable(errorMappings.isEmpty() ? null : new ErrorMapper(errorMappings));
  }
}
