package org.mule.datasense.impl.phases.typing.resolver.munit;

import org.mule.datasense.impl.model.event.ExprBuilder;
import org.mule.datasense.impl.model.event.LiteralValueExprBuilder;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

import java.util.Map;

import static java.util.Optional.ofNullable;
import static org.mule.datasense.impl.phases.builder.MuleAstParser.MULE_MUNIT;

public class MUnitSetEventParser {

  private static final ComponentIdentifier VARIABLES =
      ComponentIdentifierUtils.createFromNamespaceAndName(MULE_MUNIT, "variables");
  private static final ComponentIdentifier VARIABLE = ComponentIdentifierUtils.createFromNamespaceAndName(MULE_MUNIT, "variable");
  private static final ComponentIdentifier PAYLOAD = ComponentIdentifierUtils.createFromNamespaceAndName(MULE_MUNIT, "payload");
  private static final ComponentIdentifier ATTRIBUTES =
      ComponentIdentifierUtils.createFromNamespaceAndName(MULE_MUNIT, "attributes");
  private static final String ATTR_VARIABLE_NAME = "key";
  private static final String ATTR_VALUE = "value";
  private static final String ATTR_MEDIA_TYPE = "mediaType";

  private ExprBuilder buildExprBuilder(String textContent, String attributeValue, String mediaType) {
    if (textContent != null && textContent.trim().isEmpty()) {
      textContent = null;
    }

    String expression =
        ofNullable(textContent).orElse(ExpressionLanguageUtils.extractExpression(attributeValue).orElse(null));
    final ExprBuilder exprBuilder =
        expression != null ? new SimpleExprBuilder(expression) : new LiteralValueExprBuilder(attributeValue);
    exprBuilder.mimeType(mediaType);
    return exprBuilder;
  }

  private void parseVariables(ComponentModel componentModel, MuleEventExprBuilder muleEventExprBuilder) {
    componentModel.getInnerComponents().forEach(childComponentModel -> {
      ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(childComponentModel);
      final Map<String, String> parameters = childComponentModel.getParameters();
      if (VARIABLE.equals(componentIdentifier)) {
        String name = childComponentModel.getParameters().get(ATTR_VARIABLE_NAME);
        final ExprBuilder exprBuilder =
            buildExprBuilder(childComponentModel.getTextContent(), parameters.get(ATTR_VALUE), parameters.get(ATTR_MEDIA_TYPE));
        muleEventExprBuilder.variable(name, v -> {
          v.value(new ValueExprBuilder(exprBuilder));
        });
      }
    });
  }

  public void parse(ComponentModel setEventComponentModel, MuleEventExprBuilder muleEventExprBuilder) {
    setEventComponentModel.getInnerComponents().forEach(componentModel -> {
      ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(componentModel);
      final Map<String, String> parameters = componentModel.getParameters();
      if (PAYLOAD.equals(componentIdentifier)) {
        final ExprBuilder exprBuilder =
            buildExprBuilder(componentModel.getTextContent(), parameters.get(ATTR_VALUE), parameters.get(ATTR_MEDIA_TYPE));
        muleEventExprBuilder.message(m -> m.value(m1 -> m1.payload(exprBuilder)));
      } else if (ATTRIBUTES.equals(componentIdentifier)) {
        final ExprBuilder exprBuilder =
            buildExprBuilder(componentModel.getTextContent(), parameters.get(ATTR_VALUE), parameters.get(ATTR_MEDIA_TYPE));
        muleEventExprBuilder.message(m -> m.value(m1 -> m1.attributes(exprBuilder)));
      } else if (VARIABLES.equals(componentIdentifier)) {
        parseVariables(componentModel, muleEventExprBuilder);
      }
    });
  }
}
