/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.mule.datasense.impl.model.event.Expr;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;
import org.mule.metadata.message.api.el.TypeBindings;

public class SimpleExpr
implements Expr {
    private final String expression;
    private final String mimeType;

    public SimpleExpr(String expression, String mimeType) {
        Preconditions.checkNotNull((Object)expression);
        this.expression = expression;
        this.mimeType = mimeType;
    }

    private Optional<String> getMimeType() {
        return Optional.ofNullable(this.mimeType);
    }

    @Override
    public MetadataType resolveType(MuleEventMetadataType muleEventMetadataType, ResolveTypeContext resolveTypeContext) {
        TypeBindings typeBindings = TypeUtils.buildTypeBindings(muleEventMetadataType, resolveTypeContext.getTypeBindings());
        ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback = resolveTypeContext.getMessageCallbackFactory().createMessageCallback(this.expression);
        return this.getMimeType().map(mimeType -> resolveTypeContext.getExpressionLanguageMetadataTypeResolver().getOutputType(typeBindings, this.expression, mimeType, messageCallback)).orElse(resolveTypeContext.getExpressionLanguageMetadataTypeResolver().getOutputType(typeBindings, this.expression, messageCallback));
    }

    @Override
    public void resolveInputType(MetadataType metadataType, MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder, ResolveTypeContext resolveTypeContext) {
        resolveTypeContext.getExpressionLanguageMetadataTypeResolver().getInputType(this.expression, metadataType, muleEventMetadataTypeBuilder, resolveTypeContext.getMessageCallbackFactory().createMessageCallback(this.expression));
    }
}

