/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingUtils;
import org.mule.datasense.impl.util.LogSupport;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;

public class GlobalBindingMetadataTypes
implements LogSupport {
    public static final String GLOBAL_BINDING_MULE = "mule";
    public static final String GLOBAL_BINDING_SERVER = "server";
    public static final String GLOBAL_BINDING_APP = "app";
    public static final String GLOBAL_BINDING_CORRELATION_ID = "correlationId";
    public static final String GLOBAL_BINDING_DATA_TYPE = "dataType";
    public static final String GLOBAL_BINDING_AUTHENTICATION = "authentication";
    public static final String GLOBAL_BINDING_ITEM_SEQUENCE_INFO = "itemSequenceInfo";
    public static final String GLOBAL_BINDING_ERROR = "error";
    private static final String GLOBAL_BINDING_DATA_TYPE_CLASS = "org.mule.runtime.api.metadata.DataType";
    private static final String GLOBAL_BINDING_AUTHENTICATION_CLASS = "org.mule.runtime.api.security.Authentication";
    private static final String GLOBAL_BINDING_ITEM_SEQUENCE_INFO_CLASS = "org.mule.runtime.api.message.ItemSequenceInfo";
    private static final String TYPEDVALUE_CLASS = "org.mule.runtime.api.metadata.TypedValue";

    public static MetadataType getTypeFromJavaClass(String clazz) {
        return TypesHelper.getTypeFromJavaClass(clazz, GlobalBindingMetadataTypes.class.getClassLoader()).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to resolve class type %s", clazz)));
    }

    private static MetadataType metadataTypeFromWeaveResource(String resource, String type) {
        try {
            return TypesHelper.getTypeFromWeave(IOUtils.toString((InputStream)GlobalBindingMetadataTypes.class.getResourceAsStream(resource)), type).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to resolve weave type %s", type)));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static MetadataType correlationIdType() {
        BaseTypeBuilder typeBuilder = TypesHelper.getTypeBuilder();
        typeBuilder.stringType();
        return typeBuilder.build();
    }

    public static MetadataType dataTypeType() {
        return DataTypeTypeHolder.singleton;
    }

    public static MetadataType authenticationType() {
        return AuthenticationTypeHolder.singleton;
    }

    public static MetadataType itemSequenceInfoType() {
        return ItemSequenceInfoTypeHolder.singleton;
    }

    public static MetadataType typedValueType() {
        return TypedValueTypeHolder.singleton;
    }

    public static MetadataType appType() {
        return AppTypeHolder.singleton;
    }

    public static MetadataType serverType() {
        return ServerTypeHolder.singleton;
    }

    public static MetadataType muleType() {
        return MuleTypeHolder.singleton;
    }

    public static MetadataType errorType() {
        return ErrorHandlingUtils.errorType();
    }

    static /* synthetic */ MetadataType access$400(String x0, String x1) {
        return GlobalBindingMetadataTypes.metadataTypeFromWeaveResource(x0, x1);
    }

    private static class MuleTypeHolder {
        private static final MetadataType singleton = GlobalBindingMetadataTypes.access$400("mule-type.dw", "MuleInstanceContext");

        private MuleTypeHolder() {
        }
    }

    private static class ServerTypeHolder {
        private static final MetadataType singleton = GlobalBindingMetadataTypes.access$400("server-type.dw", "ServerContext");

        private ServerTypeHolder() {
        }
    }

    private static class AppTypeHolder {
        private static final MetadataType singleton = GlobalBindingMetadataTypes.access$400("app-type.dw", "DataWeaveArtifactContext");

        private AppTypeHolder() {
        }
    }

    private static class TypedValueTypeHolder {
        private static final MetadataType singleton = GlobalBindingMetadataTypes.getTypeFromJavaClass("org.mule.runtime.api.metadata.TypedValue");

        private TypedValueTypeHolder() {
        }
    }

    private static class ItemSequenceInfoTypeHolder {
        private static final MetadataType singleton = GlobalBindingMetadataTypes.getTypeFromJavaClass("org.mule.runtime.api.message.ItemSequenceInfo");

        private ItemSequenceInfoTypeHolder() {
        }
    }

    private static class AuthenticationTypeHolder {
        private static final MetadataType singleton = GlobalBindingMetadataTypes.getTypeFromJavaClass("org.mule.runtime.api.security.Authentication");

        private AuthenticationTypeHolder() {
        }
    }

    private static class DataTypeTypeHolder {
        private static final MetadataType singleton = GlobalBindingMetadataTypes.getTypeFromJavaClass("org.mule.runtime.api.metadata.DataType");

        private DataTypeTypeHolder() {
        }
    }
}

