/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMapper;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMapping;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

public class ErrorMappingUtils {
    private static final ComponentIdentifier ERROR_MAPPING = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "error-mapping");
    private static final String ATTR_SOURCE_TYPE = "sourceType";
    private static final String ATTR_TARGET_TYPE = "targetType";

    public static Optional<ErrorMapping> createErrorMapping(ComponentModel componentModel) {
        if (!ERROR_MAPPING.equals(ComponentIdentifierUtils.createFromComponentModel(componentModel))) {
            return Optional.empty();
        }
        Map parameters = componentModel.getParameters();
        return ErrorMapping.create((String)parameters.get(ATTR_SOURCE_TYPE), (String)parameters.get(ATTR_TARGET_TYPE));
    }

    public static Optional<ErrorMapper> createErrorMapper(MessageProcessorNode messageProcessorNode) {
        ArrayList<ErrorMapping> errorMappings = new ArrayList<ErrorMapping>();
        Optional.ofNullable(messageProcessorNode.getComponentModel()).ifPresent(componentModel -> componentModel.getInnerComponents().forEach(childComponentModel -> ErrorMappingUtils.createErrorMapping(childComponentModel).ifPresent(errorMappings::add)));
        return Optional.ofNullable(errorMappings.isEmpty() ? null : new ErrorMapper(errorMappings));
    }
}

