package org.mule.datasense.impl.model.annotations;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;

public class DefinesTypeAnnotation implements AstNodeAnnotation {

  private EventType definesEventType;

  public DefinesTypeAnnotation(EventType definesEventType) {
    Preconditions.checkNotNull(definesEventType);
    this.definesEventType = definesEventType;
  }

  public EventType getDefinesEventType() {
    return definesEventType;
  }

  public void overrideWith(EventType eventType) {
    definesEventType = TypeUtils.override(definesEventType, eventType);
  }
}
