package org.mule.datasense.impl.model.annotations;

import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.types.EventType;

import java.util.Optional;

public class TypesResolvedAnnotation implements AstNodeAnnotation {

  private final EventType result;

  public TypesResolvedAnnotation() {
    this(null);
  }

  public TypesResolvedAnnotation(EventType result) {
    this.result = result;
  }

  public Optional<EventType> getResult() {
    return Optional.ofNullable(result);
  }
}
