package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FirstSuccessfulTypeResolver extends StructuralNodeTypeResolver {

  @Override
  public Optional<ComponentModelType> getComponentModelType() {
    return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
  }

  @Override
  protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                              TypingMuleAstVisitor typingMuleAstVisitor,
                              TypingMuleAstVisitorContext typingMuleAstVisitorContext) {

    List<EventType> nestedEventTypes = new ArrayList<>();

    messageProcessorNode.getMessageProcessorNodes().forEach(pipedMessageProcessorNode -> {
      nestedEventTypes
          .add(typingMuleAstVisitor.resolveType(pipedMessageProcessorNode, inputEventType, typingMuleAstVisitorContext));
    });

    final EventType outputEventType =
        TypeUtils.union(nestedEventTypes, typingMuleAstVisitorContext.getExpressionLanguageMetadataTypeResolver());

    messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
    messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));

    return outputEventType;
  }


  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return false;
  }

  @Override
  protected boolean isSequential() {
    return false;
  }
}
