package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.MuleEventExpr;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.metadata.message.api.MuleEventMetadataType;

import java.util.Optional;
import java.util.function.Consumer;

public abstract class SetDataTypeResolver extends SingleNodeTypeResolver {

  @Override
  public Optional<ComponentModelType> getComponentModelType() {
    return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
  }

  @Override
  protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                              TypingMuleAstVisitor typingMuleAstVisitor,
                              TypingMuleAstVisitorContext visitorContext) {

    MuleEventExprBuilder muleEventExprBuilder = new MuleEventExprBuilder();

    getMuleEventExprBuilderConsumer(messageProcessorNode, inputEventType, typingMuleAstVisitor, visitorContext)
        .accept(muleEventExprBuilder);

    final MuleEventExpr muleEventExpr = muleEventExprBuilder.build();
    ResolveTypeContext resolveTypeContext = new ResolveTypeContext(visitorContext.getExpressionLanguageMetadataTypeResolver(),
                                                                   createMessageCallbackFactory(visitorContext
                                                                       .getAstNotification(),
                                                                                                messageProcessorNode
                                                                                                    .getAstNodeLocation()),
                                                                   visitorContext.getTypeBindings());
    MuleEventMetadataType muleEventMetadataType =
        muleEventExpr.resolveType(TypeUtils.asMuleEventMetadataType(inputEventType).build(), resolveTypeContext);
    EventType definesEventType = TypeUtils.asEventType(muleEventMetadataType);

    messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
    messageProcessorNode.annotate(new DefinesTypeAnnotation(definesEventType));
    return definesEventType;
  }

  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return true;
  }

  protected abstract Consumer<MuleEventExprBuilder> getMuleEventExprBuilderConsumer(MessageProcessorNode messageProcessorNode,
                                                                                    EventType inputEventType,
                                                                                    TypingMuleAstVisitor typingMuleAstVisitor,
                                                                                    TypingMuleAstVisitorContext visitorContext);
}
