/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.impl.tooling;

import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

/**
 *
 */
public class TypeInfoQueryResult implements TypedApplicationQueryResult {

  private final MetadataType input;
  private final MetadataType output;

  public TypeInfoQueryResult(MetadataType input, MetadataType output) {
    this.input = input;
    this.output = output;
  }

  public Optional<MetadataType> getInput() {
    return Optional.ofNullable(input);
  }

  public Optional<MetadataType> getOutput() {
    return Optional.ofNullable(output);
  }
}
