/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.HashMap;
import java.util.Set;
import org.mule.datasense.impl.model.annotations.FunctionBindingsAnnotation;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.annotators.Annotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.GlobalBindingMetadataTypes;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingUtils;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.ModuleDefinition;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.el.ModuleNamespace;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;

public class FunctionBindingsAnnotator
implements Annotator {
    @Override
    public void annotate(MuleApplicationNode muleApplicationNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        TypeBindings.Builder functionBindingsBuilder = TypeBindings.builder();
        this.registerMuleFunctions(functionBindingsBuilder, muleApplicationNode, annotatingMuleAstVisitorContext);
        this.registerExtensionFunctions(functionBindingsBuilder, annotatingMuleAstVisitorContext.getDataSenseProviderResolver().getDataSenseProvider().getExtensions());
        muleApplicationNode.annotate(new FunctionBindingsAnnotation(functionBindingsBuilder.build()));
    }

    private void registerMuleFunctions(TypeBindings.Builder functionBindings, MuleApplicationNode muleApplicationNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        this.registerMulePropertyFunction(functionBindings);
        this.registerMuleLookupFunction(functionBindings);
        this.registerMuleCausedByFunctionFunction(functionBindings);
    }

    private void registerMuleLookupFunction(TypeBindings.Builder functionBindings) {
        FunctionTypeBuilder lookupFunctionTypeBuilder = TypesHelper.getTypeBuilder().functionType();
        lookupFunctionTypeBuilder.with((TypeAnnotation)new DescriptionAnnotation("Executes the desired flow with the specified payload and returns its result"));
        lookupFunctionTypeBuilder.addParameterOf("flowName").stringType();
        lookupFunctionTypeBuilder.addParameterOf("payload").anyType();
        lookupFunctionTypeBuilder.addOptionalParameterOf("timeoutMillis").numberType();
        lookupFunctionTypeBuilder.returnType(GlobalBindingMetadataTypes.typedValueType());
        functionBindings.addBinding(this.createFunctionIdentifier("lookup"), (MetadataType)lookupFunctionTypeBuilder.build());
    }

    private void registerMulePropertyFunction(TypeBindings.Builder functionBindings) {
        FunctionTypeBuilder propertyFunctionTypeBuilder = TypesHelper.getTypeBuilder().functionType();
        propertyFunctionTypeBuilder.with((TypeAnnotation)new DescriptionAnnotation("Returns the value of a property"));
        propertyFunctionTypeBuilder.addParameterOf("name").stringType();
        propertyFunctionTypeBuilder.returnType().stringType();
        functionBindings.addBinding(this.createFunctionIdentifier("p"), (MetadataType)propertyFunctionTypeBuilder.build());
    }

    private void registerMuleCausedByFunctionFunction(TypeBindings.Builder functionBindings) {
        FunctionTypeBuilder functionTypeBuilder = TypesHelper.getTypeBuilder().functionType();
        functionTypeBuilder.with((TypeAnnotation)new DescriptionAnnotation("Determines whether an error matches a certain error type"));
        functionTypeBuilder.addParameterOf("error", ErrorHandlingUtils.errorType());
        functionTypeBuilder.addParameterOf("type").stringType();
        functionTypeBuilder.returnType().booleanType();
        functionBindings.addBinding(this.createFunctionIdentifier("causedBy"), (MetadataType)functionTypeBuilder.build());
    }

    private void registerExtensionFunctions(TypeBindings.Builder functionBindings, Set<ExtensionModel> extensionModels) {
        extensionModels.forEach(extensionModel -> {
            HashMap<String, MetadataType> functionsMap = new HashMap<String, MetadataType>();
            extensionModel.getFunctionModels().forEach(functionModel -> {
                FunctionTypeBuilder functionTypeBuilder = TypesHelper.getTypeBuilder().functionType();
                functionModel.getAllParameterModels().forEach(parameterModel -> functionTypeBuilder.addParameterOf(parameterModel.getName(), parameterModel.getType()));
                functionTypeBuilder.returnType(functionModel.getOutput().getType());
                functionsMap.put(this.createFunctionIdentifier((FunctionModel)functionModel), (MetadataType)functionTypeBuilder.build());
            });
            if (!functionsMap.isEmpty()) {
                ModuleDefinition.Builder module = functionBindings.module(this.createModuleIdentifier((ExtensionModel)extensionModel));
                functionsMap.forEach((arg_0, arg_1) -> ((ModuleDefinition.Builder)module).addElement(arg_0, arg_1));
            }
        });
    }

    private String createFunctionIdentifier(FunctionModel functionModel) {
        return this.createFunctionIdentifier(functionModel.getName());
    }

    private String createFunctionIdentifier(String functionName) {
        return functionName;
    }

    private String createModuleIdentifier(ExtensionModel extensionModel) {
        ModuleNamespace moduleNamespace = new ModuleNamespace(new String[]{extensionModel.getXmlDslModel().getPrefix()});
        return moduleNamespace.getElements()[0];
    }
}

