/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Collections;
import java.util.Optional;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.ThrowsErrorsTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingUtils;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.config.internal.model.ComponentModel;

public class RaiseErrorTypeResolver
extends SingleNodeTypeResolver {
    private static final String ERROR_TYPE = "type";

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    private Optional<ErrorModel> resolveErrorType(MessageProcessorNode messageProcessorNode) {
        return Optional.ofNullable(messageProcessorNode.getComponentModel()).map(ComponentModel::getParameters).map(stringStringMap -> (String)stringStringMap.get(ERROR_TYPE)).flatMap(ErrorHandlingUtils::createErrorModel);
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        this.resolveErrorType(messageProcessorNode).ifPresent(errorModel -> messageProcessorNode.annotate(new ThrowsErrorsTypeAnnotation(Collections.singleton(errorModel))));
        EventType definesEventType = new EventType();
        messageProcessorNode.annotate(new DefinesTypeAnnotation(definesEventType));
        return definesEventType;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }
}

