package org.mule.datasense.api.metadataprovider;

import static java.util.Optional.ofNullable;
import org.mule.runtime.api.meta.model.ExtensionModel;

import com.google.common.base.Preconditions;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;

import java.util.Optional;
import java.util.Set;

public class DefaultDataSenseProvider implements DataSenseProvider {

  private final ExtensionsProvider extensionsProvider;
  private final DataSenseMetadataProvider dataSenseMetadataProvider;
  private final MetadataBuilder apikitMetadataBuilder;
  private DataSenseConfiguration dataSenseConfiguration;

  public DefaultDataSenseProvider(ExtensionsProvider extensionsProvider, DataSenseMetadataProvider dataSenseMetadataProvider,
                                  MetadataBuilder apikitMetadataBuilder) {
    Preconditions.checkNotNull(extensionsProvider);
    this.extensionsProvider = extensionsProvider;
    this.dataSenseMetadataProvider = dataSenseMetadataProvider;
    this.apikitMetadataBuilder = apikitMetadataBuilder;
    this.dataSenseConfiguration = null;
  }

  public DefaultDataSenseProvider(ExtensionsProvider extensionsProvider, DataSenseMetadataProvider dataSenseMetadataProvider,
                                  MetadataBuilder apikitMetadataBuilder,
                                  DataSenseConfiguration dataSenseConfiguration) {
    this(extensionsProvider, dataSenseMetadataProvider, apikitMetadataBuilder);
    this.dataSenseConfiguration = dataSenseConfiguration;
  }

  @Override
  public Set<ExtensionModel> getExtensions() {
    return extensionsProvider.getExtensions();
  }

  public Optional<DataSenseMetadataProvider> getDataSenseMetadataProvider() {
    return ofNullable(dataSenseMetadataProvider);
  }

  @Override
  public MetadataBuilder getApikitMetadataBuilder() {
    return apikitMetadataBuilder;
  }

  @Override
  public Optional<DataSenseConfiguration> getDataSenseConfiguration() {
    return ofNullable(dataSenseConfiguration);
  }
}
