package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.annotations.GlobalBindingsAnnotation;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.GlobalBindingMetadataTypes;
import org.mule.metadata.message.api.el.TypeBindings;

public class GlobalBindingsAnnotator implements Annotator {

  @Override
  public void annotate(MuleApplicationNode muleApplicationNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    registerGlobalBindings(muleApplicationNode, annotatingMuleAstVisitorContext);
  }

  private void registerGlobalBindings(MuleApplicationNode muleApplicationNode, AnnotatingMuleAstVisitorContext visitorContext) {
    final TypeBindings.Builder typeBindingsBuilder = TypeBindings.builder();
    typeBindingsBuilder.addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_MULE, GlobalBindingMetadataTypes.muleType());
    typeBindingsBuilder.addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_SERVER, GlobalBindingMetadataTypes.serverType());
    typeBindingsBuilder.addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_APP, GlobalBindingMetadataTypes.appType());
    typeBindingsBuilder.addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_FLOW, GlobalBindingMetadataTypes.flowType());
    typeBindingsBuilder
        .addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_CORRELATION_ID, GlobalBindingMetadataTypes.correlationIdType());
    typeBindingsBuilder.addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_AUTHENTICATION,
                                   GlobalBindingMetadataTypes.authenticationType());
    typeBindingsBuilder
        .addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_DATA_TYPE, GlobalBindingMetadataTypes.dataTypeType());
    typeBindingsBuilder
        .addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_ITEM_SEQUENCE_INFO,
                    GlobalBindingMetadataTypes.itemSequenceInfoType());
    typeBindingsBuilder
        .addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_ERROR, GlobalBindingMetadataTypes.errorType());
    final TypeBindings typeBindings = typeBindingsBuilder.build();

    muleApplicationNode.annotate(new GlobalBindingsAnnotation(typeBindings));
  }
}
