package org.mule.datasense.impl.phases.builder;

import org.mule.datasense.api.ComponentResolutionScope;
import org.mule.datasense.impl.util.LocationUtils;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.internal.model.ComponentModel;

public class ComponentResolutionScopeStrategy implements DataSenseResolutionScopeStrategy {

  private final ComponentResolutionScope dataSenseResolutionScope;

  public ComponentResolutionScopeStrategy(ComponentResolutionScope dataSenseResolutionScope) {
    this.dataSenseResolutionScope = dataSenseResolutionScope;
  }

  @Override
  public boolean match(ComponentModel componentModel) {
    final Location location = LocationUtils.valueOf(componentModel.getComponentLocation().getLocation());
    return location == null
        || location.getGlobalName().equals(dataSenseResolutionScope.getLocation().getGlobalName());
  }
}
