package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.phases.typing.resolver.batch.BatchAggregatorTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.batch.BatchJobTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.batch.BatchOnCompleteTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.batch.BatchProcessRecordsTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.batch.BatchStepTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitAfterSuiteTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitAfterTestTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitBeforeSuiteTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitBeforeTestTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitSetEventTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitSetNullPayloadTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitTestBehaviorTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitTestExecutionTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitTestTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitTestValidationTypeResolver;

import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_AGGREGATORS_AGGREGATION_COMPLETE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_AGGREGATORS_AGGREGATOR_LISTENER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_AGGREGATORS_GROUP_BASED_AGGREGATOR;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_AGGREGATORS_ROUTE_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_AGGREGATORS_SIZE_BASED_AGGREGATOR;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ASYNC;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ASYNC_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ASYNC_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_BATCH_AGGREGATOR;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_BATCH_AGGREGATOR_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_BATCH_AGGREGATOR_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_BATCH_JOB;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_BATCH_JOB_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_BATCH_JOB_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_BATCH_ON_COMPLETE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_BATCH_ON_COMPLETE_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_BATCH_ON_COMPLETE_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_BATCH_PROCESS_RECORDS;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_BATCH_STEP;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_CHOICE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_COLLECTION_SPLITTER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_CONTAINER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_EE_CACHE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ENRICHER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ERROR_HANDLER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FIRST_SUCCESSFUL;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FLOW;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_REF;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FOREACH;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FOREACH_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_AGGREGATORS_INCREMENTAL_AGGREGATION;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_GLOBAL_ERROR_HANDLER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_LOGGER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_SET_EVENT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_SET_NULL_PAYLOAD;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_TEST;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_TEST_BEHAVIOR;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_TEST_EXECUTION;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_TEST_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_TEST_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_TEST_VALIDATION;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ON_ERROR_CONTINUE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ON_ERROR_PROPAGATE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ON_ERROR_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_OPERATION_CALL;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_OTHERWISE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_RAISE_ERROR;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ROUTE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_PARSE_TEMPLATE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_REMOVE_VARIABLE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ROUND_ROBIN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SCHEDULER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_PROCESSOR_CHAIN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SCATTER_GATHER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SET_PAYLOAD;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SET_PAYLOAD_ATTRIBUTES;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SET_VARIABLE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SUBFLOW;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_AGGREGATORS_TIME_BASED_AGGREGATOR;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_TRANSFORM;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_TRY;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_UNKNOWN_PROCESSOR;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_WHEN;

public class DataSenseTypeResolverRegistry extends TypeResolverRegistry {

  public DataSenseTypeResolverRegistry() {
    register(COMPONENT_IDENTIFIER_FLOW, new FlowTypeResolver());
    register(COMPONENT_IDENTIFIER_FLOW_SCOPE_IN, new FlowTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_FLOW_SCOPE_OUT, new FlowTypeResolver.ScopeOut());
    register(COMPONENT_IDENTIFIER_SUBFLOW, new FlowTypeResolver());
    register(COMPONENT_IDENTIFIER_LOGGER, new LoggerTypeResolver());
    register(COMPONENT_IDENTIFIER_COLLECTION_SPLITTER, new CollectionSplitterTypeResolver());
    register(COMPONENT_IDENTIFIER_SCHEDULER, new SchedulerTypeResolver());
    register(COMPONENT_IDENTIFIER_TRANSFORM, new TransformTypeResolver());
    register(COMPONENT_IDENTIFIER_OPERATION_CALL, new OperationCallTypeResolver());
    register(COMPONENT_IDENTIFIER_SET_PAYLOAD_ATTRIBUTES, new SetPayloadAttributesTypeResolver());
    register(COMPONENT_IDENTIFIER_SET_PAYLOAD, new SetPayloadTypeResolver());
    register(COMPONENT_IDENTIFIER_SET_VARIABLE, new SetVariableTypeResolver());
    register(COMPONENT_IDENTIFIER_REMOVE_VARIABLE, new RemoveVariableTypeResolver());
    register(COMPONENT_IDENTIFIER_PROCESSOR_CHAIN, new ProcessorChainTypeResolver());
    register(COMPONENT_IDENTIFIER_CONTAINER, new ProcessorChainTypeResolver());
    register(COMPONENT_IDENTIFIER_UNKNOWN_PROCESSOR, new UnknownProcessorTypeResolver());
    register(COMPONENT_IDENTIFIER_PARSE_TEMPLATE, new ParseTemplateTypeResolver());

    // Router: Choice
    register(COMPONENT_IDENTIFIER_CHOICE, new ChoiceTypeResolver());
    register(COMPONENT_IDENTIFIER_WHEN, new ChoiceTypeResolver.ChoiceWhenTypeResolver());
    register(COMPONENT_IDENTIFIER_OTHERWISE, new ChoiceTypeResolver.ChoiceOtherwiseTypeResolver());
    // Router: Enricher
    register(COMPONENT_IDENTIFIER_ENRICHER, new EnricherTypeResolver());
    // Router: ForEach
    register(COMPONENT_IDENTIFIER_FOREACH, new ForEachTypeResolver());
    register(COMPONENT_IDENTIFIER_FOREACH_SCOPE_IN, new ForEachTypeResolver.ForEachScopeIn());
    // Router: ScatterGather
    register(COMPONENT_IDENTIFIER_SCATTER_GATHER, new ScatterGatherTypeResolver());
    register(COMPONENT_IDENTIFIER_ROUTE, new RouteTypeResolver());

    register(COMPONENT_IDENTIFIER_FLOW_REF, new FlowRefTypeResolver());
    // try
    register(COMPONENT_IDENTIFIER_TRY, new TryTypeResolver());
    register(COMPONENT_IDENTIFIER_ERROR_HANDLER, new ErrorHandlerTypeResolver());
    register(COMPONENT_IDENTIFIER_GLOBAL_ERROR_HANDLER, new GlobalErrorHandlerTypeResolver());
    register(COMPONENT_IDENTIFIER_ON_ERROR_CONTINUE, new OnErrorTypeResolver(true));
    register(COMPONENT_IDENTIFIER_ON_ERROR_PROPAGATE, new OnErrorTypeResolver(false));
    register(COMPONENT_IDENTIFIER_ON_ERROR_SCOPE_IN, new OnErrorTypeResolver.ScopeIn());
    // Other Scopes
    register(COMPONENT_IDENTIFIER_FIRST_SUCCESSFUL, new FirstSuccessfulTypeResolver());
    register(COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL,
             new UntilSuccessfulTypeResolver(COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_IN,
                                             COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_IN, new UntilSuccessfulTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_OUT, new UntilSuccessfulTypeResolver.ScopeOut());
    register(COMPONENT_IDENTIFIER_ROUND_ROBIN, new RoundRobinTypeResolver());
    register(COMPONENT_IDENTIFIER_ASYNC,
             new AsyncTypeResolver(COMPONENT_IDENTIFIER_ASYNC_SCOPE_IN, COMPONENT_IDENTIFIER_ASYNC_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_ASYNC_SCOPE_IN, new AsyncTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_ASYNC_SCOPE_OUT, new AsyncTypeResolver.ScopeOut());
    register(COMPONENT_IDENTIFIER_EE_CACHE, new EECacheTypeResolver());

    // Batch
    register(COMPONENT_IDENTIFIER_BATCH_JOB,
             new BatchJobTypeResolver(COMPONENT_IDENTIFIER_BATCH_JOB_SCOPE_IN, COMPONENT_IDENTIFIER_BATCH_JOB_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_BATCH_JOB_SCOPE_IN, new BatchJobTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_BATCH_JOB_SCOPE_OUT, new BatchJobTypeResolver.ScopeOut());
    register(COMPONENT_IDENTIFIER_BATCH_PROCESS_RECORDS, new BatchProcessRecordsTypeResolver());
    register(COMPONENT_IDENTIFIER_BATCH_ON_COMPLETE,
             new BatchOnCompleteTypeResolver(COMPONENT_IDENTIFIER_BATCH_ON_COMPLETE_SCOPE_IN,
                                             COMPONENT_IDENTIFIER_BATCH_ON_COMPLETE_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_BATCH_ON_COMPLETE_SCOPE_IN, new BatchOnCompleteTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_BATCH_ON_COMPLETE_SCOPE_OUT, new BatchOnCompleteTypeResolver.ScopeOut());
    register(COMPONENT_IDENTIFIER_BATCH_STEP, new BatchStepTypeResolver());
    register(COMPONENT_IDENTIFIER_BATCH_AGGREGATOR,
             new BatchAggregatorTypeResolver(COMPONENT_IDENTIFIER_BATCH_AGGREGATOR_SCOPE_IN,
                                             COMPONENT_IDENTIFIER_BATCH_AGGREGATOR_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_BATCH_AGGREGATOR_SCOPE_IN, new BatchAggregatorTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_BATCH_AGGREGATOR_SCOPE_OUT, new BatchAggregatorTypeResolver.ScopeOut());

    // Munit
    register(COMPONENT_IDENTIFIER_MUNIT_TEST,
             new MUnitTestTypeResolver(COMPONENT_IDENTIFIER_MUNIT_TEST_SCOPE_IN, COMPONENT_IDENTIFIER_MUNIT_TEST_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_MUNIT_TEST_SCOPE_IN, new MUnitTestTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_MUNIT_TEST_SCOPE_OUT, new MUnitTestTypeResolver.ScopeOut());

    register(COMPONENT_IDENTIFIER_MUNIT_TEST_BEHAVIOR, new MUnitTestBehaviorTypeResolver());
    register(COMPONENT_IDENTIFIER_MUNIT_TEST_EXECUTION, new MUnitTestExecutionTypeResolver());
    register(COMPONENT_IDENTIFIER_MUNIT_TEST_VALIDATION, new MUnitTestValidationTypeResolver());

    register(COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE,
             new MUnitBeforeSuiteTypeResolver(COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE_SCOPE_IN,
                                              COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE_SCOPE_IN, new MUnitBeforeSuiteTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE_SCOPE_OUT, new MUnitBeforeSuiteTypeResolver.ScopeOut());

    register(COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE,
             new MUnitAfterSuiteTypeResolver(COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE_SCOPE_IN,
                                             COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE_SCOPE_IN, new MUnitAfterSuiteTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE_SCOPE_OUT, new MUnitAfterSuiteTypeResolver.ScopeOut());

    register(COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST,
             new MUnitBeforeTestTypeResolver(COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST_SCOPE_IN,
                                             COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST_SCOPE_IN, new MUnitBeforeTestTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST_SCOPE_OUT, new MUnitBeforeTestTypeResolver.ScopeOut());

    register(COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST,
             new MUnitAfterTestTypeResolver(COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST_SCOPE_IN,
                                            COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST_SCOPE_IN, new MUnitAfterTestTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST_SCOPE_OUT, new MUnitAfterTestTypeResolver.ScopeOut());

    register(COMPONENT_IDENTIFIER_MUNIT_SET_EVENT, new MUnitSetEventTypeResolver());
    register(COMPONENT_IDENTIFIER_MUNIT_SET_NULL_PAYLOAD, new MUnitSetNullPayloadTypeResolver());

    // Aggregators
    register(COMPONENT_IDENTIFIER_AGGREGATORS_AGGREGATOR_LISTENER, new AggregatorListenerTypeResolver());

    register(COMPONENT_IDENTIFIER_AGGREGATORS_TIME_BASED_AGGREGATOR, new AggregatorTypeResolver());
    register(COMPONENT_IDENTIFIER_AGGREGATORS_GROUP_BASED_AGGREGATOR, new AggregatorTypeResolver());
    register(COMPONENT_IDENTIFIER_AGGREGATORS_SIZE_BASED_AGGREGATOR, new AggregatorTypeResolver());

    register(COMPONENT_IDENTIFIER_AGGREGATORS_INCREMENTAL_AGGREGATION, new AggregatorRouteTypeResolver());
    register(COMPONENT_IDENTIFIER_AGGREGATORS_AGGREGATION_COMPLETE, new AggregatorRouteTypeResolver());
    register(COMPONENT_IDENTIFIER_AGGREGATORS_ROUTE_SCOPE_IN, new AggregatorRouteTypeResolver.ScopeIn());

    register(COMPONENT_IDENTIFIER_RAISE_ERROR, new RaiseErrorTypeResolver());
  }
}
