package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.ExprBuilder;
import org.mule.datasense.impl.model.event.LiteralValueExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.datasense.impl.util.extension.ExtensionUtils;

import java.util.Optional;

import static java.util.Optional.ofNullable;

public abstract class SetMuleEventDataTypeResolver extends SetDataTypeResolver {

  private final static String FIELD_VALUE = "value";

  protected Optional<String> getFieldValue(MessageProcessorNode messageProcessorNode) {
    return ofNullable(messageProcessorNode.getComponentModel().getParameters().get(FIELD_VALUE));
  }

  protected ExprBuilder resolveExprBuilder(MessageProcessorNode messageProcessorNode) {
    final String expression =
        getFieldValue(messageProcessorNode).flatMap(ExpressionLanguageUtils::extractExpression).orElse(null);
    ExprBuilder result = expression == null ? new LiteralValueExprBuilder(
                                                                          getFieldValue(messageProcessorNode).orElse(""))
        : new SimpleExprBuilder(expression);
    ExtensionUtils.findMimeType(messageProcessorNode.getComponentModel()).ifPresent(result::mimeType);
    return result;
  }


}
