package org.mule.datasense.impl.phases.typing.resolver.enricher;

import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

import java.util.Optional;

import static org.mule.datasense.impl.phases.builder.MuleAstParser.MULE_CORE;

public class EnricherParser {

  static final ComponentIdentifier ENRICH = ComponentIdentifierUtils.createFromNamespaceAndName(MULE_CORE, "enrich");
  static final String ATTR_SOURCE = "source";
  static final String ATTR_TARGET = "target";

  private void processEnrichment(ComponentModel componentModel, MuleEventExprBuilder muleEventExprBuilder) {
    ExpressionLanguageUtils
        .extractExpression(Optional.ofNullable(componentModel.getParameters().get(ATTR_SOURCE)).orElse("#[payload]"))
        .ifPresent(expression -> {
          String target = componentModel.getParameters().get(ATTR_TARGET);
          if (target != null) {
            if (target.equals("payload")) {
              muleEventExprBuilder.message(m -> m.value(m1 -> m1.payload(new SimpleExprBuilder(expression))));
            } else if (target.equals("attributes")) {
              muleEventExprBuilder.message(m -> m.value(m1 -> m1.attributes(new SimpleExprBuilder(expression))));
            } else if (!ExpressionLanguageUtils.isExpression(target)) {
              muleEventExprBuilder.variable(target, v -> v.value(new ValueExprBuilder(new SimpleExprBuilder(expression))));
            }
          }
        });
  }

  public MuleEventExprBuilder parse(ComponentModel componentModel) {
    MuleEventExprBuilder muleEventExprBuilder = new MuleEventExprBuilder();
    processEnrichment(componentModel, muleEventExprBuilder);
    componentModel.getInnerComponents().forEach(childComponentModel -> {
      ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(childComponentModel);
      if (ENRICH.equals(componentIdentifier)) {
        processEnrichment(childComponentModel, muleEventExprBuilder);
      }
    });
    return muleEventExprBuilder;
  }
}
