package org.mule.datasense.impl.util;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;

public class AstMessageCallbackFactory implements MessageCallbackFactory {

  private final AstNotification astNotification;
  private final AstNodeLocation astNodeLocation;

  public AstMessageCallbackFactory(AstNotification astNotification, AstNodeLocation astNodeLocation) {
    Preconditions.checkNotNull(astNotification);
    Preconditions.checkNotNull(astNodeLocation);

    this.astNotification = astNotification;
    this.astNodeLocation = astNodeLocation;
  }

  public ExpressionLanguageMetadataTypeResolver.MessageCallback createMessageCallback(String expression) {
    return new ExpressionLanguageMetadataTypeResolver.MessageCallback() {

      @Override
      public void warning(String message, ExpressionLanguageMetadataTypeResolver.MessageLocation messageLocation) {
        astNotification.reportWarning(astNodeLocation, NotificationMessages.MSG_SCRIPTING_LANGUAGE_WARNING(expression, message));
      }

      @Override
      public void error(String message, ExpressionLanguageMetadataTypeResolver.MessageLocation messageLocation) {
        astNotification.reportError(astNodeLocation, NotificationMessages.MSG_SCRIPTING_LANGUAGE_ERROR(expression, message));
      }
    };
  }
}
