package org.mule.datasense.impl.util.extension;

import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceCallbackModel;

public class SourceCallbackModelTransform {

  private final ParameterGroupModelTransform parameterGroupModelTransform;

  public SourceCallbackModelTransform(
                                      ParameterGroupModelTransform parameterGroupModelTransform) {
    this.parameterGroupModelTransform = parameterGroupModelTransform;
  }

  public SourceCallbackModelTransform() {
    this(new ParameterGroupModelTransform());
  }

  public SourceCallbackModel transform(SourceCallbackModel sourceCallbackModel) {
    return new ImmutableSourceCallbackModel(sourceCallbackModel.getName(), sourceCallbackModel.getDescription(),
                                            parameterGroupModelTransform.transform(sourceCallbackModel.getParameterGroupModels()),
                                            sourceCallbackModel.getDisplayModel().orElse(null),
                                            sourceCallbackModel.getModelProperties());
  }

}
