/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.stream.Stream;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.datasense.impl.util.MessageCallbackFactory;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;

public class TargetProcessingSupport {
    private MetadataType resolveTargetMetadataType(MuleEventMetadataType muleEventMetadataType, String targetValue, String mimeType, TypingMuleAstVisitorContext visitorContext, MessageCallbackFactory messageCallbackFactory) {
        ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver = visitorContext.getExpressionLanguageMetadataTypeResolver();
        return ExpressionLanguageUtils.extractExpression(targetValue).map(targetValueExpression -> ExpressionLanguageUtils.resolveExpressionType(targetValueExpression, mimeType, muleEventMetadataType, visitorContext.getTypeBindings(), expressionLanguageMetadataTypeResolver, messageCallbackFactory.createMessageCallback((String)targetValueExpression))).orElse((MetadataType)TypeUtils.asMessageMetadataTypeOrEmptyMessage(muleEventMetadataType.getMessageType()));
    }

    private EventType resolveTargetEventType(String target, String targetValue, String mimeType, MuleEventMetadataType muleEventMetadataType, TypingMuleAstVisitorContext visitorContext, MessageCallbackFactory messageCallbackFactory) {
        MetadataType targetMetadataType = this.resolveTargetMetadataType(muleEventMetadataType, targetValue, mimeType, visitorContext, messageCallbackFactory);
        return new EventType(Stream.of(new VarDecl(target, targetMetadataType)));
    }

    private EventType resolveVariablesEventType(MuleEventMetadataType muleEventMetadataType) {
        return new EventType(muleEventMetadataType.getVariables().getFields().stream().map(objectFieldType -> new VarDecl(objectFieldType.getKey().getName().getLocalPart(), objectFieldType.getValue())));
    }

    private EventType resolveAttributesEventType(MuleEventMetadataType muleEventMetadataType) {
        return muleEventMetadataType.getMessageType().getAttributesType().map(attributesType -> new EventType(Stream.of(new VarDecl("#attributes#", (MetadataType)attributesType)))).orElse(new EventType());
    }

    public EventType processTarget(String target, String targetValue, String mimeType, MuleEventMetadataType muleEventMetadataType, TypingMuleAstVisitorContext visitorContext, MessageCallbackFactory messageCallbackFactory) {
        if (target == null && mimeType == null) {
            return TypeUtils.asEventType(muleEventMetadataType);
        }
        boolean includeAttributes = false;
        if (target == null) {
            target = "#payload#";
            targetValue = "#[payload]";
            includeAttributes = true;
        }
        EventType eventType = this.resolveVariablesEventType(muleEventMetadataType);
        if (includeAttributes) {
            eventType = TypeUtils.merge(eventType, this.resolveAttributesEventType(muleEventMetadataType));
        }
        return TypeUtils.merge(eventType, this.resolveTargetEventType(target, targetValue, mimeType, muleEventMetadataType, visitorContext, messageCallbackFactory));
    }

    public EventType processTarget(String target, String targetValue, MuleEventMetadataType muleEventMetadataType, TypingMuleAstVisitorContext visitorContext, MessageCallbackFactory messageCallbackFactory) {
        return this.processTarget(target, targetValue, null, muleEventMetadataType, visitorContext, messageCallbackFactory);
    }

    public EventType processTarget(String target, String targetValue, String mimeType, EventType eventType, TypingMuleAstVisitorContext visitorContext, MessageCallbackFactory messageCallbackFactory) {
        MuleEventMetadataType muleEventMetadataType = TypeUtils.asMuleEventMetadataType(eventType).build();
        return this.processTarget(target, targetValue, mimeType, muleEventMetadataType, visitorContext, messageCallbackFactory);
    }

    public EventType processTarget(String target, String targetValue, EventType eventType, TypingMuleAstVisitorContext visitorContext, MessageCallbackFactory messageCallbackFactory) {
        return this.processTarget(target, targetValue, null, eventType, visitorContext, messageCallbackFactory);
    }
}

